/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.platform.ui.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.simantics.platform.ui.SimanticsConsole;

public class ConsoleAppender
extends AppenderBase<ILoggingEvent> {
    private final SimanticsConsole console;
    private final DateFormat formatter;

    ConsoleAppender(SimanticsConsole console) {
        assert (console != null);
        this.console = console;
        this.formatter = new SimpleDateFormat("dd.LL.yyyy HH:mm:ss.SSS");
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected void append(ILoggingEvent e) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        b.append(this.formatter.format(new Date(e.getTimeStamp())));
        b.append("]: ");
        b.append(e.getFormattedMessage());
        this.console.write(b.toString());
    }
}

