/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.simantics.utils.ui.gfx.ImageCache;

public class HSVAdjustmentImageDescriptor
extends ImageDescriptor {
    public static final PaletteData DEFAULT_PALETTEDATA = new PaletteData(0xFF0000, 65280, 255);
    ImageDescriptor desc;
    float h;
    float s;
    float v;

    public static ImageDescriptor adjustHue(ImageDescriptor image, float hue) {
        assert (image != null);
        if (hue == 0.0f) {
            return image;
        }
        hue = HSVAdjustmentImageDescriptor.mod360(hue);
        return new HSVAdjustmentImageDescriptor(image, hue, 1.0f, 1.0f);
    }

    public static ImageDescriptor adjust(ImageDescriptor image, float hue, float saturation, float value) {
        assert (image != null);
        if (saturation == 1.0f && value == 1.0f && hue == 0.0f) {
            return image;
        }
        return new HSVAdjustmentImageDescriptor(image, hue, saturation, value);
    }

    public static ImageDescriptor adjustSaturation(ImageDescriptor image, float saturation) {
        assert (image != null);
        if (saturation == 1.0f) {
            return image;
        }
        return new HSVAdjustmentImageDescriptor(image, 0.0f, saturation, 1.0f);
    }

    public static ImageDescriptor adjustValue(ImageDescriptor image, float value) {
        assert (image != null);
        if (value == 1.0f) {
            return image;
        }
        return new HSVAdjustmentImageDescriptor(image, 0.0f, 1.0f, value);
    }

    public HSVAdjustmentImageDescriptor(ImageDescriptor image, float hue, float saturation, float value) {
        this.desc = image;
        this.h = hue;
        this.s = saturation;
        this.v = value;
    }

    public ImageData getImageData() {
        PaletteData palette = DEFAULT_PALETTEDATA;
        ImageData orig = ImageCache.getInstance().getImage(this.desc).getImageData();
        ImageData id = new ImageData(orig.width, orig.height, 24, palette);
        id.setAlpha(0, 0, 0);
        PaletteData origPalette = orig.palette;
        ImageData mask = null;
        if (orig.getTransparencyType() == 2 || orig.getTransparencyType() == 4) {
            mask = orig.getTransparencyMask();
        }
        int x = 0;
        while (x < orig.width) {
            int y = 0;
            while (y < orig.height) {
                RGB rgb = origPalette.getRGB(orig.getPixel(x, y));
                float[] hsv = rgb.getHSB();
                hsv[0] = HSVAdjustmentImageDescriptor.mod360(hsv[0] + this.h);
                hsv[1] = hsv[1] * this.s;
                hsv[2] = hsv[2] * this.v;
                rgb = new RGB(hsv[0], hsv[1], hsv[2]);
                id.setPixel(x, y, palette.getPixel(rgb));
                int alpha = mask == null ? orig.getAlpha(x, y) : (mask.getPixel(x, y) == 1 ? 255 : 0);
                id.setAlpha(x, y, alpha);
                ++y;
            }
            ++x;
        }
        return id;
    }

    public static float mod360(float value) {
        int d = value >= 0.0f ? (int)value / 360 : (int)value / 360 - 1;
        return value - (float)d * 360.0f;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HSVAdjustmentImageDescriptor)) {
            return false;
        }
        HSVAdjustmentImageDescriptor other = (HSVAdjustmentImageDescriptor)((Object)obj);
        return other.desc.equals(this.desc) && other.h == this.h && other.s == this.s && other.v == this.v;
    }

    public int hashCode() {
        return this.desc.hashCode() ^ new Float(this.h).hashCode() ^ new Float(this.s).hashCode() ^ new Float(this.v).hashCode();
    }
}

