/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.ExternalRef;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.spreadsheet.solver.SpreadsheetCell;
import org.simantics.spreadsheet.solver.SpreadsheetSCLConstant;

class ExternalRefData
implements ExternalRef.ExternalRefListener {
    private final SpreadsheetBook book;
    private final long referenceKey;
    private final ExternalRef ref;
    private boolean isDisposed = false;
    private Variant value = SpreadsheetBook.DEFAULT_VALUE;

    public ExternalRefData(SpreadsheetBook book, long referenceKey, ExternalRef ref) {
        this.book = book;
        this.referenceKey = referenceKey;
        this.ref = ref;
        ref.listen(book.context, this);
    }

    public Variant getContent() {
        return this.value;
    }

    public ExternalRef getRef() {
        return this.ref;
    }

    @Override
    public void newValue(Variant newVariant) {
        SpreadsheetSCLConstant ssc;
        Object content;
        SpreadsheetCell cell = this.book.cellByReferenceKey(this.referenceKey);
        if (cell.getContent() instanceof SpreadsheetSCLConstant && (content = (ssc = (SpreadsheetSCLConstant)cell.getContent()).getContent()).equals(this.ref)) {
            this.value = newVariant;
            this.book.fireChanges(this.book.invalidate(cell));
            return;
        }
        this.isDisposed = true;
    }

    @Override
    public boolean isDisposed() {
        if (this.isDisposed) {
            return true;
        }
        return this.book.isDisposed();
    }
}

