/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.simantics.Simantics;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.DecorationSVGNode;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.TextGridNode;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.g2d.utils.CanvasUtils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.IG2DNodeVisitor;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.BackgroundNode;
import org.simantics.scenegraph.g2d.nodes.BoundsNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.scenegraph.g2d.nodes.LinkNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.g2d.nodes.SelectionNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.trend.impl.ItemNode;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SCLScenegraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScenegraph.class);
    private static final String MAIN_SECTION = "main";
    private static final String SELECTION_SECTION = "selection";
    private static final String SELECTION_MASK_SECTION = "selectionMask";
    private static final String[] ALL_SECTIONS = new String[]{"main", "selection", "selectionMask"};
    private static final String OPACITY = "0.0001";
    private static final Function1<Set<?>, Map<?, ?>> mapper = p0 -> p0.stream().collect(Collectors.toMap(p1 -> p1, p2 -> p2));

    @Deprecated
    public static ICanvasSceneGraphProvider getICanvasSceneGraphProvider(Resource model, Resource diagram, String diagramRVI) throws DatabaseException, InterruptedException {
        ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider((Resource)model, (Resource)diagram, (String)diagramRVI);
        return provider;
    }

    @Deprecated
    public static void disposeSceneGraphProvider(ICanvasSceneGraphProvider provider) {
        provider.dispose();
    }

    public static <T> T doWithICanvasSceneGraphProvider(Resource diagram, Function1<ICanvasSceneGraphProvider, T> func) throws DatabaseException {
        return (T)SCLScenegraph.doWithICanvasSceneGraphProvider(diagram, (ICanvasSceneGraphProvider provider) -> func.apply(provider));
    }

    public static <T> T doWithICanvasSceneGraphProvider(Resource diagram, Function<ICanvasSceneGraphProvider, T> func) throws DatabaseException {
        Tuple2 result = (Tuple2)Simantics.getSession().syncRequest((Read)new ResourceRead<Tuple2>(diagram){

            public Tuple2 perform(ReadGraph graph) throws DatabaseException {
                Resource indexRoot = (Resource)graph.syncRequest((Read)new IndexRoot(this.resource));
                String diagramRVI = Variables.getRVI((ReadGraph)graph, (Resource)this.resource);
                return new Tuple2((Object)indexRoot, (Object)diagramRVI);
            }
        });
        ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider((Resource)((Resource)result.c0), (Resource)diagram, (String)((String)result.c1));
        try {
            T t = func.apply(provider);
            return t;
        }
        finally {
            provider.dispose();
        }
    }

    public static <T> T doWithCanvasContext(Resource diagram, Function1<ICanvasContext, T> func) throws DatabaseException {
        return (T)SCLScenegraph.doWithCanvasContext(diagram, (ICanvasContext canvasContext) -> func.apply(canvasContext));
    }

    public static <T> T doWithCanvasContext(Resource diagram, Function<ICanvasContext, T> func) throws DatabaseException {
        return (T)SCLScenegraph.doWithICanvasSceneGraphProvider(diagram, (ICanvasSceneGraphProvider provider) -> func.apply(provider.getCanvasContext()));
    }

    public static String getNodeTransform(ICanvasContext ctx, String name) {
        Set texts = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        for (TextNode text : texts) {
            String nodeName = NodeUtil.getNodeName((INode)text);
            if (!nodeName.equals(name)) continue;
            String transform = text.getTransform().toString();
            return transform;
        }
        return "No node found";
    }

    public static String getNodeText(ICanvasContext ctx, String name) {
        Set texts = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        for (TextNode text : texts) {
            String nodeName = NodeUtil.getNodeName((INode)text);
            if (!nodeName.equals(name)) continue;
            String texti = text.getText();
            return texti;
        }
        return "No node found";
    }

    public static String getNodeCount(ICanvasContext ctx) {
        G2DSceneGraph g2 = ctx.getSceneGraph();
        int amount = NodeUtil.countTreeNodes((INode)g2);
        return "Node count: " + amount;
    }

    public static String getAllNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), G2DSceneGraph.class);
        int amount = g2.size() + 1;
        return "All nodes: " + amount;
    }

    public static String getBoundsNodes(ICanvasContext ctx) {
        Set bn = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), BoundsNode.class);
        int amount = bn.size();
        return "BoundsNodes: " + amount;
    }

    public static String getBackgroundNodes(ICanvasContext ctx) {
        Set bg = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), BackgroundNode.class);
        int amount = bg.size();
        return "BackgroundNodes: " + amount;
    }

    public static String getDataNodes(ICanvasContext ctx) {
        Set dn = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), DataNode.class);
        int amount = dn.size();
        return "DataNodes: " + amount;
    }

    public static String getNavigationNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), NavigationNode.class);
        int amount = g2.size();
        return "NavigationNodes: " + amount;
    }

    public static String getParentNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), G2DParentNode.class);
        int amount = g2.size();
        return "ParentNodes: " + amount;
    }

    public static String getDecorationNodes(ICanvasContext ctx) {
        Set deco = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), DecorationSVGNode.class);
        int amount = deco.size();
        return "DecorationNodes: " + amount;
    }

    public static String getSingleElementNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), SingleElementNode.class);
        int amount = g2.size();
        return "SingleElementNodes: " + amount;
    }

    public static String getConnectionNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), ConnectionNode.class);
        int amount = g2.size();
        return "ConnectionNodes: " + amount;
    }

    public static String getTextNodes(ICanvasContext ctx) {
        Set tn = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        Set tgn = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextGridNode.class);
        int amount = tn.size() + tgn.size();
        return "TextNodes: " + amount;
    }

    public static String getItemNodes(ICanvasContext ctx) {
        Set item = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), ItemNode.class);
        int amount = item.size();
        return "ItemNodes: " + amount;
    }

    public static String editNodeText(ICanvasContext ctx, String module, String previous_value, String new_value) {
        Set textGridNodes = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        for (TextNode modulenode : textGridNodes) {
            if (!module.equals(modulenode.getText())) continue;
            ParentNode parentnode = modulenode.getParent();
            Collection textnodes = parentnode.getNodes();
            for (TextNode valuenode : textnodes) {
                if (!previous_value.equals(valuenode.getText())) continue;
                valuenode.activateEdit(0, null, ctx);
                valuenode.setText(new_value);
                valuenode.fireTextEditingEnded();
                return "Modified module " + module + " with value " + new_value;
            }
            return "Not found module : " + module;
        }
        return "No nodes in scenegraph!";
    }

    public static List<Integer> getBackgroundColor(ICanvasContext ctx) {
        Color color = (Color)ctx.getDefaultHintContext().getHint(Hints.KEY_BACKGROUND_COLOR);
        if (color == null) {
            return null;
        }
        ArrayList<Integer> rgba = new ArrayList<Integer>(4);
        rgba.add(color.getRed());
        rgba.add(color.getGreen());
        rgba.add(color.getBlue());
        rgba.add(color.getAlpha());
        return rgba;
    }

    public static String sceneGraphTest(ICanvasContext ctx, String module, String value) {
        boolean module_founded = false;
        boolean value_founded = false;
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), G2DSceneGraph.class);
        System.out.println("Total amount of nodes: " + g2.size() + 1);
        Set grid = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextGridNode.class);
        Integer textGridNodeAmount = grid.size();
        System.out.println("Amount of TextGridNodes " + textGridNodeAmount);
        Set texts = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        Integer textNodeAmount = grid.size();
        System.out.println("Amount of TextNodes " + textNodeAmount);
        for (TextNode node : texts) {
            if (module.equals(node.getText())) {
                module_founded = true;
                System.out.println("Correct module " + module + " founded.");
            }
            if (!value.equals(node.getText())) continue;
            value_founded = true;
            System.out.println("Correct value " + value + " founded.");
        }
        if (value_founded && module_founded) {
            return "Found both correct module " + module + " and value " + value;
        }
        if (!value_founded && module_founded) {
            return "Found only correct module " + module + " but not value " + value;
        }
        if (value_founded && !module_founded) {
            return "Found only correct value " + value + " but not module " + module;
        }
        return "Didn't found either module " + module + " or value " + value;
    }

    public static boolean copyPaste(final ICanvasContext source_ctx, final ICanvasContext target_ctx, List<Resource> modules) throws DatabaseException {
        IDiagram idiagram = (IDiagram)source_ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        DataElementMap dem = (DataElementMap)idiagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
        if (dem != null) {
            final ArrayList<IElement> newSelection = new ArrayList<IElement>();
            for (Resource module : modules) {
                IElement element = dem.getElement(idiagram, (Object)module);
                if (element != null) {
                    newSelection.add(element);
                    continue;
                }
                throw new DatabaseException("Could not find IElement for " + element);
            }
            ThreadUtils.syncExec((IThreadWorkQueue)source_ctx.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (source_ctx.isDisposed()) {
                        return;
                    }
                    Selection selection = (Selection)source_ctx.getAtMostOneItemOfClass(Selection.class);
                    if (selection != null) {
                        selection.setSelection(0, newSelection);
                    }
                    CanvasUtils.sendCommand((ICanvasContext)source_ctx, (Command)Commands.COPY);
                    CanvasUtils.sendCommand((ICanvasContext)target_ctx, (Command)Commands.PASTE);
                }
            });
            while (source_ctx.getEventQueue().size() > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
            ThreadUtils.syncExec((IThreadWorkQueue)source_ctx.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        return true;
    }

    public static Element renderSVGNode(SVGGraphics2D svgGenerator, IG2DNode node) {
        try {
            svgGenerator.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            svgGenerator.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            svgGenerator.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            node.render((Graphics2D)svgGenerator);
        }
        catch (Throwable t) {
            LOGGER.error("Problems rendering scene graph to SVG", t);
        }
        return svgGenerator.getRoot();
    }

    public static String printSVGDocument(Element doce) {
        StringBuilder result = new StringBuilder();
        NodeList nl = doce.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("standalone", "no");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(new DOMSource(nl.item(i)), new StreamResult(new OutputStreamWriter((OutputStream)os, "UTF-8")));
                os.flush();
                os.close();
            }
            catch (Throwable t) {
                LOGGER.error("Problems formatting SVGDocument to text.", t);
            }
            result.append(new String(os.toByteArray()));
            ++i;
        }
        return result.toString();
    }

    public static String renderSVG3(ICanvasContext ctx) {
        return SCLScenegraph.renderSVG3(ctx, -1.0, -1.0);
    }

    public static String renderSVG3(ICanvasContext ctx, double width, double height) {
        return SCLScenegraph.renderSVG0(width, height, ctx, p0 -> p0.stream().collect(Collectors.toMap(p1 -> p1, p2 -> p2)));
    }

    private static Object[] createURIBasedL0Identifier(ReadGraph graph, Resource component) throws DatabaseException {
        String uri = graph.getPossibleURI(component);
        int hashCode = uri.hashCode();
        Random random = new Random(hashCode);
        long l1 = random.nextLong();
        long l2 = random.nextLong();
        return new Object[]{l1, l2};
    }

    public static String renderSVG(ICanvasContext ctx, double width, double height) {
        return SCLScenegraph.renderSVG0(width, height, ctx, mapper);
    }

    public static String renderSVG(ICanvasContext ctx) {
        return SCLScenegraph.renderSVG(ctx, -1.0, -1.0);
    }

    public static String renderSVGMapIdentifiers(ICanvasContext ctx) {
        return SCLScenegraph.renderSVGMapIdentifiers(ctx, -1.0, -1.0);
    }

    public static String renderSVGMapIdentifiers(ICanvasContext ctx, double width, double height) {
        return SCLScenegraph.renderSVG0(width, height, ctx, new Function1<Set<?>, Map<?, ?>>(){

            public Map<?, ?> apply(Set<?> p0) {
                try {
                    return (Map)Simantics.getSession().syncRequest((Read)new UnaryRead<Set<?>, Map<?, ?>>(p0){

                        public Map<?, ?> perform(ReadGraph graph) throws DatabaseException {
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            return ((Set)this.parameter).stream().collect(Collectors.toMap(p -> p, p -> {
                                block6: {
                                    try {
                                        if (!(p instanceof Resource)) break block6;
                                        Resource element = (Resource)p;
                                        if (!graph.isInstanceOf(element, diagramResource.Element)) return p;
                                        Resource component = graph.getPossibleObject(element, modelingResources.ElementToComponent);
                                        if (component != null) {
                                            GUID identifier = (GUID)graph.getPossibleRelatedValue(component, layer0.identifier, GUID.BINDING);
                                            if (identifier != null) {
                                                return Arrays.toString(SCLScenegraph.createURIBasedL0Identifier(graph, component));
                                            }
                                            LOGGER.error("Component {} does not have GUID identifier!", (Object)component);
                                            return p;
                                        }
                                        if (graph.isInstanceOf(element, diagramResource.Connection) || graph.isInstanceOf(element, diagramResource.Terminal)) {
                                            return graph.getURI(element).hashCode();
                                        }
                                        if (!graph.hasStatement(element, layer0.HasName)) return "";
                                        return graph.getURI(element).hashCode();
                                    }
                                    catch (DatabaseException e) {
                                        throw new RuntimeDatabaseException((Throwable)e);
                                    }
                                }
                                LOGGER.error("Parameter p {} is not resource but it is {}", p, p.getClass());
                                return p;
                            }));
                        }
                    });
                }
                catch (DatabaseException e) {
                    LOGGER.error("Could not apply mappings", (Throwable)e);
                    throw new RuntimeDatabaseException((Throwable)e);
                }
            }
        });
    }

    private static String renderSVG0(double width, double height, ICanvasContext ctx, Function1<Set<?>, Map<?, ?>> mappingFunction) {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        Generator svgGenerator = new Generator(document);
        RenderSVGContext result = new RenderSVGContext();
        double[] matrix = new double[6];
        try {
            Rectangle2D rtreeBounds;
            Selection selection = (Selection)ctx.getAtMostOneItemOfClass(Selection.class);
            if (selection != null) {
                IDiagram d = (IDiagram)ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
                selection.setSelection(0, (Collection)d.getElements());
            }
            G2DSceneGraph sg = ctx.getSceneGraph();
            sg.performCleanup();
            G2DParentNode root = (G2DParentNode)sg.getRootNode();
            RTreeNode rtree = (RTreeNode)NodeUtil.getNearestChildByClass((G2DParentNode)root, RTreeNode.class);
            Rectangle2D content = rtreeBounds = NodeUtil.getLocalBounds((INode)rtree);
            if (content != null) {
                int offset = 6;
                double scale = width < 0.0 || height < 0.0 ? 1.0 : Math.min((width - (double)(2 * offset)) / content.getWidth(), (height - (double)(2 * offset)) / content.getHeight());
                AffineTransform tr = new AffineTransform();
                tr.translate(offset, offset);
                tr.scale(scale, scale);
                tr.translate(-content.getX(), -content.getY());
                tr.getMatrix(matrix);
                svgGenerator.setSVGCanvasSize(new Dimension((int)Math.ceil(scale * content.getWidth()) + 2 * offset, (int)Math.ceil(scale * content.getHeight()) + 2 * offset));
            } else {
                svgGenerator.setSVGCanvasSize(new Dimension(100, 100));
            }
            result.append(MAIN_SECTION, "<g class=\"symbols\">");
            result.append(SELECTION_SECTION, "<g class=\"selections\">");
            result.append(SELECTION_MASK_SECTION, "<g class=\"selectionMasks\">");
            KeyVisitor keyVisitor = new KeyVisitor();
            sg.accept((IG2DNodeVisitor)keyVisitor);
            Set<Object> keys = keyVisitor.getKeys();
            Map mappings = (Map)mappingFunction.apply(keys);
            PrintingVisitor visitor = new PrintingVisitor(svgGenerator, result, mappings);
            sg.accept((IG2DNodeVisitor)visitor);
        }
        catch (Throwable t) {
            LOGGER.error("Problems rendering canvas context to SVG", t);
        }
        result.append(ALL_SECTIONS, "</g>");
        StringBuilder res = new StringBuilder();
        res.append("<svg width=\"100%\" height=\"100%\" stroke=\"black\">");
        res.append("<g transform=\"matrix(").append(matrix[0]).append(",").append(matrix[1]).append(",").append(matrix[2]).append(",").append(matrix[3]).append(",").append(matrix[4]).append(",").append(matrix[5]).append(")\">");
        res.append(result.get(MAIN_SECTION));
        res.append(result.get(SELECTION_SECTION));
        res.append(result.get(SELECTION_MASK_SECTION));
        res.append("</g>");
        res.append("</svg>");
        return res.toString();
    }

    static /* synthetic */ Object[] access$0(ReadGraph readGraph, Resource resource) throws DatabaseException {
        return SCLScenegraph.createURIBasedL0Identifier(readGraph, resource);
    }

    static /* synthetic */ Logger access$1() {
        return LOGGER;
    }

    static class Generator
    extends SVGGraphics2D {
        int elemLevel = 0;
        String newElementId = null;
        ArrayList<Element> elements = new ArrayList();
        public static final String svgNS = "http://www.w3.org/2000/svg";

        public Generator(SVGGeneratorContext ctx, boolean textAsShapes) {
            super(ctx, textAsShapes);
        }

        public Generator(Document document) {
            super(document);
            this.getGeneratorContext().setComment(null);
        }

        public Element getRoot() {
            Element root = super.getRoot();
            for (Element e : this.elements) {
                root.appendChild(e);
            }
            return root;
        }

        public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
            if (G2DRenderingHints.KEY_BEGIN_ELEMENT == arg0) {
                ++this.elemLevel;
            }
            if (G2DRenderingHints.KEY_ELEMENT_ID == arg0) {
                this.newElementId = arg1 != null ? arg1.toString() : UUID.randomUUID().toString();
            }
            if (G2DRenderingHints.KEY_END_ELEMENT == arg0) {
                --this.elemLevel;
                if (this.elemLevel == 0) {
                    Element group = this.getDOMFactory().createElement("g");
                    group.setAttributeNS(null, "id", this.newElementId);
                    group.setAttributeNS(null, "class", arg1.toString());
                    this.getRoot(group);
                    this.elements.add(group);
                }
            }
            super.setRenderingHint(arg0, arg1);
        }
    }

    private static class KeyVisitor
    implements IG2DNodeVisitor {
        private Set<Object> keys = new HashSet<Object>();

        private KeyVisitor() {
        }

        public void enter(IG2DNode node) {
            Object key;
            if (node instanceof SingleElementNode && (key = ((SingleElementNode)node).getKey()) != null) {
                this.keys.add(key);
            }
        }

        public void leave(IG2DNode node) {
        }

        public Set<Object> getKeys() {
            return this.keys;
        }
    }

    private static class PrintingVisitor
    implements IG2DNodeVisitor {
        int indent = 0;
        HashMap<SingleElementNode, RenderSVGContext> senBuilders = new HashMap();
        private RenderSVGContext result;
        private SVGGraphics2D svgGenerator;
        private Map<?, ?> mappings;

        public PrintingVisitor(SVGGraphics2D svgGenerator, RenderSVGContext result, Map<?, ?> mappings) {
            this.result = result;
            this.mappings = mappings;
            this.svgGenerator = svgGenerator;
        }

        private String getKey(SingleElementNode node) {
            String key = node.getKey() != null ? (this.mappings.containsKey(node.getKey()) ? this.mappings.get(node.getKey()).toString() : node.getKey().toString()) : Long.toString(node.getId());
            return key;
        }

        public void enter(IG2DNode node) {
            RenderSVGContext parentBuilder = this.getParentBuilder(node);
            ++this.indent;
            if (node instanceof ConnectionNode) {
                for (RouteGraphNode n : NodeUtil.collectNodes((INode)node, RouteGraphNode.class)) {
                    n.setIgnoreSelection(true);
                }
                String key = this.getKey((SingleElementNode)((ConnectionNode)node));
                parentBuilder.append(SCLScenegraph.MAIN_SECTION, "\n<g class=\"connection\" id=\"" + key + "\">");
                parentBuilder.append(SCLScenegraph.SELECTION_SECTION, "\n<g style=\"visibility:hidden\" class=\"selection\" id=\"" + key + "\">");
                parentBuilder.append(SCLScenegraph.SELECTION_MASK_SECTION, "\n<g class=\"selectionMask\" opacity=\"0.0001\" id=\"" + key + "\">");
                Element doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                String svg = SCLScenegraph.printSVGDocument(doc);
                parentBuilder.append(SCLScenegraph.MAIN_SECTION, svg);
                for (RouteGraphNode n : NodeUtil.collectNodes((INode)node, RouteGraphNode.class)) {
                    n.setIgnoreSelection(false);
                }
                doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                svg = SCLScenegraph.printSVGDocument(doc);
                parentBuilder.append(SCLScenegraph.SELECTION_SECTION, svg);
                BasicStroke bs = new BasicStroke(10.0f);
                for (RouteGraphNode n : NodeUtil.collectNodes((INode)node, RouteGraphNode.class)) {
                    n.setDynamicStroke((Stroke)bs);
                }
                doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                svg = SCLScenegraph.printSVGDocument(doc);
                parentBuilder.append(SCLScenegraph.SELECTION_MASK_SECTION, svg);
                parentBuilder.append(SCLScenegraph.SELECTION_MASK_SECTION, "\n</g>");
                parentBuilder.append(SCLScenegraph.SELECTION_SECTION, "\n</g>");
                parentBuilder.append(SCLScenegraph.MAIN_SECTION, "\n</g>");
            } else if (this.isSelection0(node)) {
                SelectionNode n = (SelectionNode)node;
                SingleElementNode parentSEN = (SingleElementNode)NodeUtil.getNearestParentOfType((INode)node, SingleElementNode.class);
                if (parentSEN != null) {
                    RenderSVGContext parentBuilder2 = this.getParentBuilder((IG2DNode)parentSEN);
                    String key = this.getKey(parentSEN);
                    n.setIgnore(false);
                    Element doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                    n.setIgnore(true);
                    String svg = SCLScenegraph.printSVGDocument(doc);
                    parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, "\n<g style=\"visibility:hidden\" class=\"selection\" id=\"" + key + "\">");
                    parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, svg);
                    parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, "\n</g>");
                    parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "\n<g class=\"selectionMask\" id=\"" + key + "\">");
                    Rectangle2D rect = n.getRect();
                    if (rect.getHeight() == rect.getHeight() && rect.getWidth() == rect.getWidth()) {
                        parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "<rect style=\"fill:#fff\" opacity=\"0.0001\"");
                        parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, " x=\"" + rect.getX() + "\" y=\"" + rect.getY() + "\"");
                        parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, " width=\"" + rect.getWidth() + "\" height=\"" + rect.getHeight() + "\"");
                        parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "></rect>");
                    }
                    parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "\n</g>");
                }
            } else if (node instanceof SelectionNode) {
                Element doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                String svg = SCLScenegraph.printSVGDocument(doc);
                parentBuilder.append(SCLScenegraph.MAIN_SECTION, "<g>");
                parentBuilder.append(SCLScenegraph.MAIN_SECTION, svg);
                parentBuilder.append(SCLScenegraph.MAIN_SECTION, "\n</g>");
            } else if (node instanceof SVGNode) {
                SVGNode svg = (SVGNode)node;
                AffineTransform at = svg.getTransform();
                if (!at.isIdentity()) {
                    if (at.getScaleX() == 1.0 && at.getScaleY() == 1.0 && at.getShearX() == 0.0 && at.getShearY() == 0.0) {
                        String m = "translate(" + at.getTranslateX() + " " + at.getTranslateY() + ")";
                        parentBuilder.append(SCLScenegraph.MAIN_SECTION, "\n<g transform=\"" + m + "\">");
                    } else {
                        double[] ds = new double[6];
                        at.getMatrix(ds);
                        String m = "matrix(" + ds[0] + " " + ds[1] + " " + ds[2] + " " + ds[3] + " " + ds[4] + " " + ds[5] + ")";
                        parentBuilder.append(SCLScenegraph.MAIN_SECTION, "\n<g transform=\"" + m + "\">");
                    }
                }
                parentBuilder.append(SCLScenegraph.MAIN_SECTION, svg.getSVGText());
                if (!at.isIdentity()) {
                    parentBuilder.append(SCLScenegraph.MAIN_SECTION, "\n</g>");
                }
            } else if (node instanceof G2DParentNode) {
                AffineTransform at = node.getTransform();
                if (node instanceof SingleElementNode) {
                    SingleElementNode sen = (SingleElementNode)node;
                    String key = this.getKey(sen);
                    String typeClass = sen.getTypeClass();
                    String clazz = "definedElement";
                    if (typeClass != null && !typeClass.isEmpty()) {
                        clazz = String.valueOf(clazz) + " " + typeClass;
                    }
                    parentBuilder.append(SCLScenegraph.MAIN_SECTION, "\n<g class=\"" + clazz + "\" id=\"" + key + "\">");
                    this.senBuilders.put(sen, new RenderSVGContext());
                }
                if (!at.isIdentity()) {
                    if (at.getScaleX() == 1.0 && at.getScaleY() == 1.0 && at.getShearX() == 0.0 && at.getShearY() == 0.0) {
                        String m = "translate(" + at.getTranslateX() + " " + at.getTranslateY() + ")";
                        parentBuilder.append(ALL_SECTIONS, "\n<g transform=\"" + m + "\">");
                    } else {
                        double[] ds = new double[6];
                        at.getMatrix(ds);
                        String m = "matrix(" + ds[0] + " " + ds[1] + " " + ds[2] + " " + ds[3] + " " + ds[4] + " " + ds[5] + ")";
                        parentBuilder.append(ALL_SECTIONS, "\n<g transform=\"" + m + "\">");
                    }
                }
            } else if (node instanceof TextNode) {
                TextNode text = (TextNode)node;
                SingleElementNode parentSEN = (SingleElementNode)NodeUtil.getNearestParentOfType((INode)node, SingleElementNode.class);
                if (parentSEN != null) {
                    text.setShowSelection(false);
                    Element doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                    String svg = SCLScenegraph.printSVGDocument(doc);
                    parentBuilder.append(SCLScenegraph.MAIN_SECTION, svg);
                    RenderSVGContext parentBuilder2 = this.getParentBuilder((IG2DNode)parentSEN);
                    String key = this.getKey(parentSEN);
                    text.setShowSelection(true);
                    doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                    svg = SCLScenegraph.printSVGDocument(doc);
                    parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, "\n<g style=\"visibility:hidden\" class=\"selection\" id=\"" + key + "\">");
                    parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, svg);
                    parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, "\n</g>");
                    parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "\n<g class=\"selectionMask\" id=\"" + key + "\">");
                    Rectangle2D rect = text.getBounds();
                    if (rect.getHeight() == rect.getHeight() && rect.getWidth() == rect.getWidth()) {
                        parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "<rect style=\"fill:#fff\" opacity=\"0.0001\"");
                        parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, " x=\"" + rect.getX() + "\" y=\"" + rect.getY() + "\"");
                        parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, " width=\"" + rect.getWidth() + "\" height=\"" + rect.getHeight() + "\"");
                        parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "></rect>");
                    }
                    parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "\n</g>");
                }
            } else if (!(node instanceof RouteGraphNode) && !(node instanceof LinkNode)) {
                try {
                    Element doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                    NodeList gList = doc.getElementsByTagName("g");
                    if (gList.getLength() == 0) {
                        return;
                    }
                    boolean hasContent = false;
                    int i = 0;
                    while (i < gList.getLength()) {
                        Node gNode = gList.item(i);
                        if (gNode.hasChildNodes()) {
                            hasContent = true;
                            break;
                        }
                        ++i;
                    }
                    if (!hasContent) {
                        return;
                    }
                    String svg = SCLScenegraph.printSVGDocument(doc);
                    if (node instanceof ElementPainter.SelectionShapeNode) {
                        SingleElementNode parentSEN = (SingleElementNode)NodeUtil.getNearestParentOfType((INode)node, SingleElementNode.class);
                        if (parentSEN != null) {
                            String key = this.getKey(parentSEN);
                            RenderSVGContext parentBuilder2 = this.getParentBuilder((IG2DNode)parentSEN);
                            parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, "\n<g style=\"visibility:hidden\" class=\"selection\" id=\"" + key + "\">");
                            parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, svg);
                            parentBuilder2.append(SCLScenegraph.SELECTION_SECTION, "\n</g>");
                            parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "\n<g class=\"selectionMask\" id=\"" + key + "\">");
                            Rectangle2D rect = node.getBounds();
                            if (rect.getHeight() == rect.getHeight() && rect.getWidth() == rect.getWidth()) {
                                parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "<rect style=\"fill:#fff\" opacity=\"0.0001\"");
                                parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, " x=\"" + rect.getX() + "\" y=\"" + rect.getY() + "\"");
                                parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, " width=\"" + rect.getWidth() + "\" height=\"" + rect.getHeight() + "\"");
                                parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "></rect>");
                            }
                            parentBuilder2.append(SCLScenegraph.SELECTION_MASK_SECTION, "\n</g>");
                        }
                    } else {
                        parentBuilder.append(SCLScenegraph.MAIN_SECTION, "<g class=\"" + node.getSimpleClassName() + "\">");
                        parentBuilder.append(SCLScenegraph.MAIN_SECTION, svg);
                        parentBuilder.append(SCLScenegraph.MAIN_SECTION, "\n</g>");
                    }
                }
                catch (Exception exception) {}
            }
        }

        private boolean isSelection0(IG2DNode node) {
            if (node instanceof SelectionNode) {
                SelectionNode sn = (SelectionNode)node;
                return sn.getSelectionId() == 0;
            }
            return false;
        }

        private RenderSVGContext getParentBuilder(IG2DNode node) {
            INode parentSEN = NodeUtil.getNearestParentOfType((INode)node, SingleElementNode.class);
            if (parentSEN instanceof G2DSceneGraph) {
                return this.result;
            }
            RenderSVGContext parentBuilder = this.senBuilders.get(parentSEN);
            if (parentBuilder == null) {
                return this.result;
            }
            return parentBuilder;
        }

        public void leave(IG2DNode node) {
            if (!(node instanceof ConnectionNode) && !(node instanceof SVGNode) && node instanceof G2DParentNode) {
                AffineTransform at;
                RenderSVGContext parentBuilder = this.getParentBuilder(node);
                if (node instanceof SingleElementNode) {
                    SingleElementNode sen = (SingleElementNode)node;
                    RenderSVGContext b = this.senBuilders.get(sen);
                    String content = b.get(SCLScenegraph.MAIN_SECTION);
                    if (content.isEmpty()) {
                        if (sen.getKey() != null) {
                            for (SelectionNode n : NodeUtil.collectNodes((INode)node, SelectionNode.class)) {
                                n.setIgnore(true);
                            }
                            Element doc = SCLScenegraph.renderSVGNode(this.svgGenerator, node);
                            String svg = SCLScenegraph.printSVGDocument(doc);
                            parentBuilder.append(SCLScenegraph.MAIN_SECTION, svg);
                        }
                    } else {
                        parentBuilder.append(b);
                    }
                }
                if (!(at = node.getTransform()).isIdentity()) {
                    parentBuilder.append(ALL_SECTIONS, "</g>");
                }
                if (node instanceof SingleElementNode) {
                    SingleElementNode cfr_ignored_0 = (SingleElementNode)node;
                    parentBuilder.append(SCLScenegraph.MAIN_SECTION, "</g>");
                }
            }
            --this.indent;
        }
    }

    static class RenderSVGContext {
        Map<String, StringBuilder> documents = new HashMap<String, StringBuilder>();

        RenderSVGContext() {
        }

        public void append(String[] keys, String svgText) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.append(key, svgText);
                ++n2;
            }
        }

        public void append(String key, String svgText) {
            StringBuilder builder = this.documents.get(key);
            if (builder == null) {
                builder = new StringBuilder();
                this.documents.put(key, builder);
            }
            builder.append(svgText);
        }

        public void append(RenderSVGContext other) {
            for (String key : other.documents.keySet()) {
                this.append(key, other.get(key));
            }
        }

        public String get(String key) {
            StringBuilder builder = this.documents.get(key);
            if (builder == null) {
                return "";
            }
            return builder.toString();
        }
    }
}

