/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.map.hash.TIntLongHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.query.AssertedPredicates;
import org.simantics.db.impl.query.AssertedStatements;
import org.simantics.db.impl.query.ChildMap;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.Objects;
import org.simantics.db.impl.query.OrderedSet;
import org.simantics.db.impl.query.Predicates;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryFactory;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.Statements;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.TypeHierarchy;
import org.simantics.db.impl.query.Types;
import org.simantics.db.impl.query.URIToResource;
import org.simantics.db.impl.query.ValueQuery;
import org.simantics.db.service.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDeserializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDeserializer.class);
    QueryCache qc;
    QuerySupport qs;
    ClusterSupport cs;
    private byte[] bytes;
    private int byteIndex;
    private TIntLongHashMap clusterKeys = new TIntLongHashMap();
    private Map<Integer, QueryFactory> ids = new HashMap<Integer, QueryFactory>();

    public QueryDeserializer(QueryProcessor qp, byte[] bytes) {
        this.qc = qp.cache;
        this.qs = qp.querySupport;
        this.cs = this.qs.getClusterSupport();
        this.bytes = bytes;
    }

    public byte readByte() {
        return this.bytes[this.byteIndex++];
    }

    public int readLE4() {
        int result = Bytes.readLE4((byte[])this.bytes, (int)this.byteIndex);
        this.byteIndex += 4;
        return result;
    }

    public long readLE8() {
        long result = Bytes.readLE8((byte[])this.bytes, (int)this.byteIndex);
        this.byteIndex += 8;
        return result;
    }

    public byte[] readBytes(int len) {
        byte[] result = Arrays.copyOfRange(this.bytes, this.byteIndex, this.byteIndex + len);
        this.byteIndex += len;
        return result;
    }

    public void readHeaders() {
        int key;
        int idsSize = this.readLE4();
        int i = 0;
        while (i < idsSize) {
            int size = this.readLE4();
            byte[] data = this.readBytes(size);
            String id = new String(data);
            key = this.readLE4();
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(String.valueOf(id) + "Factory");
                QueryFactory qf = (QueryFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.ids.put(key, qf);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            ++i;
        }
        int clusterKeysSize = this.readLE4();
        int i2 = 0;
        while (i2 < clusterKeysSize) {
            long cluster = this.readLE8();
            key = this.readLE4();
            this.clusterKeys.put(key, cluster);
            ++i2;
        }
    }

    public QueryFactory readFactory() {
        int key = this.readLE4();
        return this.ids.get(key);
    }

    public void readQueries() {
        int count = this.readLE4();
        int i = 0;
        while (i < count) {
            QueryFactory qf = this.readFactory();
            try {
                qf.read(this);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public int readResource() throws DatabaseException {
        int key = this.readLE4();
        if (key < 0) {
            return key;
        }
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKey(key);
        long cluster = this.clusterKeys.get(clusterKey);
        ClusterBase cb = this.cs.getClusterByClusterId(cluster);
        return ClusterTraitsBase.createResourceKey(cb.getClusterKey(), ClusterTraitsBase.getResourceIndexFromResourceKey(key));
    }

    public byte[] readByteArray() {
        int len = this.readLE4();
        if (len == -1) {
            return null;
        }
        return this.readBytes(len);
    }

    public String readString() {
        return new String(this.readByteArray());
    }

    public ObjectResourceIdMap<String> createChildMap() {
        return this.qs.createChildMap();
    }

    AssertedPredicates readAssertedPredicates() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateAssertedPredicates(r);
    }

    AssertedStatements readAssertedStatements() throws DatabaseException {
        int r1 = this.readResource();
        int r2 = this.readResource();
        return this.qc.getOrCreateAssertedStatements(r1, r2);
    }

    ChildMap readChildMap() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateChildMap(r);
    }

    DirectObjects readDirectObjects() throws DatabaseException {
        int r1 = this.readResource();
        int r2 = this.readResource();
        return this.qc.getOrCreateDirectObjects(r1, r2);
    }

    DirectPredicates readDirectPredicates() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateDirectPredicates(r);
    }

    Objects readObjects() throws DatabaseException {
        int r1 = this.readResource();
        int r2 = this.readResource();
        return this.qc.getOrCreateObjects(r1, r2);
    }

    OrderedSet readOrderedSet() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateOrderedSet(r);
    }

    Predicates readPredicates() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreatePredicates(r);
    }

    PrincipalTypes readPrincipalTypes() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreatePrincipalTypes(r);
    }

    RelationInfoQuery readRelationInfoQuery() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateRelationInfoQuery(r);
    }

    Statements readStatements() throws DatabaseException {
        int r1 = this.readResource();
        int r2 = this.readResource();
        return this.qc.getOrCreateStatements(r1, r2);
    }

    SuperRelations readSuperRelations() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateSuperRelations(r);
    }

    SuperTypes readSuperTypes() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateSuperTypes(r);
    }

    TypeHierarchy readTypeHierarchy() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateTypeHierarchy(r);
    }

    Types readTypes() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateTypes(r);
    }

    URIToResource readURIToResource() throws DatabaseException {
        String s = this.readString();
        return this.qc.getOrCreateURIToResource(s);
    }

    ValueQuery readValueQuery() throws DatabaseException {
        int r = this.readResource();
        return this.qc.getOrCreateValueQuery(r);
    }
}

