/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.simantics.utils.FileUtils;

public class CodeGen {
    int indent = 4;
    GenerationInfo signatureR1RelationInfo = new GenerationInfo("int r", "r", "keyR", "long", "InternalProcedure<RelationInfo>", "", false);
    GenerationInfo signatureR1Bytes = new GenerationInfo("int r", "r", "keyR", "long", "InternalProcedure<byte[]>", "", false);
    GenerationInfo signatureR1IntSet = new GenerationInfo("int r", "r", "keyR", "long", "InternalProcedure<IntSet>", "", false);
    GenerationInfo signatureR1IP = new GenerationInfo("int r", "r", "keyR", "long", "IntProcedure", "", false);
    GenerationInfo signatureR2IP = new GenerationInfo("int r1, int r2", "r1,r2", "keyR2", "long", "IntProcedure", "", false);
    GenerationInfo signatureR2TIP = new GenerationInfo("int r1, int r2", "r1,r2", "keyR2", "long", "TripleIntProcedure", "", false);
    GenerationInfo signatureID1 = new GenerationInfo("String id", "id", "keyID", "String", "InternalProcedure<Integer>", "", false);
    GenerationInfo signatureID2 = new GenerationInfo("String id", "id", "keyID", "String", "InternalProcedure<TObjectIntHashMap<String>>", "", false);
    GenerationInfo signatureChildMap = new GenerationInfo("int r", "r", "keyR", "long", "InternalProcedure<ObjectResourceIdMap<String>>", "", false);
    GenerationInfo signatureRead = new GenerationInfo("Read<?> r", "r", "id", "long", "AsyncProcedure", "", true);
    GenerationInfo signatureAsyncRead = new GenerationInfo("AsyncRead<?> r", "r", "id", "long", "AsyncProcedure", "", true);
    GenerationInfo signatureMultiRead = new GenerationInfo("MultiRead<?> r", "r", "id", "long", "SyncMultiProcedure", "", false);
    GenerationInfo signatureAsyncMultiRead = new GenerationInfo("AsyncMultiRead<?> r", "r", "id", "long", "AsyncMultiProcedure", "", false);
    GenerationInfo signatureExternalRead = new GenerationInfo("ExternalRead<?> r", "r", "id", "long", "AsyncProcedure", ", graph", false);

    private void line(StringBuilder content, String line) {
        int i = 0;
        while (i < this.indent) {
            content.append(" ");
            ++i;
        }
        content.append(line);
        content.append("\n");
    }

    public void generateQuery(StringBuilder content, String clazz, GenerationInfo signature, boolean runnerShortcut, boolean genReturn) {
        this.generateGetOrCreate(content, clazz, signature);
        this.generateRemove(content, clazz, signature);
        this.generateRunner(content, clazz, signature, runnerShortcut, genReturn);
    }

    public void generateRunner(StringBuilder content, String clazz, GenerationInfo signature, boolean shortcut, boolean genReturn) {
        this.line(content, "public static " + (genReturn ? "Object" : "void") + " runner" + clazz + "(ReadGraphImpl graph, " + signature.p1 + ", CacheEntry parent, ListenerBase listener, final " + signature.procedure + " procedure" + (signature.useNeedsToBlock ? ", boolean needsToBlock" : "") + ") throws DatabaseException {");
        this.line(content, "    QueryCache cache  = graph.processor.cache;");
        if (shortcut) {
            this.line(content, "    if(parent == null && listener == null && !cache.shouldCache(graph.processor, " + signature.keyName + ")) {");
            this.line(content, "        if (SINGLE) {");
            this.line(content, "            " + clazz + " e = cache.peek" + clazz + "(" + signature.keyName + ");");
            this.line(content, "            if (e != null && e.isReady()) {");
            this.line(content, "                " + (genReturn ? "return " : "") + "e.performFromCache(graph, procedure);");
            if (!genReturn) {
                this.line(content, "                return;");
            }
            this.line(content, "            }");
            this.line(content, "        }");
            this.line(content, "        " + (genReturn ? "return " : "") + clazz + ".computeForEach(graph, " + signature.keyName + ", null, procedure" + (signature.useNeedsToBlock ? ", needsToBlock" : "") + ");");
            if (!genReturn) {
                this.line(content, "        return;");
            }
            this.line(content, "    }");
        }
        if (signature.useNeedsToBlock) {
            this.line(content, "    " + clazz + " entry = (" + clazz + ")cache.getOrCreate" + clazz + "(graph, " + signature.keyName + ", needsToBlock);");
            this.line(content, "    if(entry == null) {");
            this.line(content, "      graph.processor.schedule(new SessionTask(graph) {");
            this.line(content, "        @Override");
            this.line(content, "        public void run0(int thread) {");
            this.line(content, "          try {");
            this.line(content, "            runner" + clazz + "(graph, r, parent, listener, procedure, needsToBlock);");
            this.line(content, "          } catch (DatabaseException e) {");
            this.line(content, "            Logger.defaultLogError(e);");
            this.line(content, "          }");
            this.line(content, "        }");
            this.line(content, "      });");
            this.line(content, "      return null;");
            this.line(content, "    }");
        } else {
            this.line(content, "    " + clazz + " entry = (" + clazz + ")cache.getOrCreate" + clazz + "(graph, " + signature.keyName + ");");
        }
        this.line(content, "    " + signature.procedure + " procedure_ = procedure != null ? procedure : emptyProcedure" + clazz + ";");
        this.line(content, "    if(entry.isReady()) {");
        this.line(content, "      graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);");
        if (genReturn) {
            this.line(content, "      Object result = entry.performFromCache(graph, procedure_);");
            this.line(content, "      graph.processor.listening.registerFirstKnown(listener, result);");
            this.line(content, "      return result;");
        } else {
            this.line(content, "      entry.performFromCache(graph, procedure_);");
        }
        this.line(content, "    }");
        this.line(content, "    else {");
        this.line(content, "      assert(entry.isPending());");
        if (genReturn) {
            this.line(content, "      graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);");
            if (shortcut) {
                this.line(content, "      Object result = " + clazz + ".computeForEach(graph, " + signature.keyName + ", entry, procedure_" + (signature.useNeedsToBlock ? ", needsToBlock" : "") + ");");
            } else {
                this.line(content, "      entry.compute(graph, procedure_);");
            }
            this.line(content, "      graph.processor.listening.registerFirstKnown(listener, result);");
            this.line(content, "      return result;");
        } else {
            this.line(content, "      graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);");
            if (shortcut) {
                this.line(content, "      " + clazz + ".computeForEach(graph, " + signature.keyName + ", entry, procedure_" + (signature.useNeedsToBlock ? ", needsToBlock" : "") + ");");
            } else {
                this.line(content, "      entry.compute(graph, procedure_);");
            }
        }
        this.line(content, "    }");
        this.line(content, "}");
        this.line(content, "");
        String lower = String.valueOf(Character.toLowerCase(clazz.charAt(0))) + clazz.substring(1);
        this.line(content, "private " + clazz + " peek" + clazz + "(" + signature.p1 + ") {");
        this.line(content, "    synchronized(" + lower + "Map) {");
        this.line(content, "        return (" + clazz + ") " + lower + "Map.get(" + signature.keyName + ");");
        this.line(content, "    }");
        this.line(content, "}");
        this.line(content, "");
    }

    public void generateRemove(StringBuilder content, String clazz, GenerationInfo signature) {
        String lower = String.valueOf(Character.toLowerCase(clazz.charAt(0))) + clazz.substring(1);
        this.line(content, "void remove(" + clazz + " entry) {");
        this.line(content, "    synchronized(" + lower + "Map) {");
        this.line(content, "        " + lower + "Map.remove(entry.id);");
        this.line(content, "    }");
        this.line(content, "}");
        this.line(content, "");
    }

    public void generateGetOrCreate(StringBuilder content, String clazz, GenerationInfo signature) {
        String lower = String.valueOf(Character.toLowerCase(clazz.charAt(0))) + clazz.substring(1);
        this.line(content, clazz + " getOrCreate" + clazz + "(ReadGraphImpl graph, " + signature.p1 + (signature.useNeedsToBlock ? ", boolean needsToBlock" : "") + ") throws DatabaseException {");
        this.line(content, "    " + clazz + " existing = null;");
        this.line(content, "    synchronized(" + lower + "Map) {");
        this.line(content, "        existing = (" + clazz + ")" + lower + "Map.get(" + signature.keyName + ");");
        this.line(content, "        if(existing == null) {");
        this.line(content, "            existing = new " + clazz + "(" + signature.keyName + signature.entryCreationArguments + ");");
        this.line(content, "            existing.setPending(querySupport);");
        this.line(content, "            " + lower + "Map.put(" + signature.keyToId + "(" + signature.keyName + "), existing);");
        this.line(content, "            size++;");
        this.line(content, "            return existing;");
        this.line(content, "        }");
        this.line(content, "        if(existing.requiresComputation()) {");
        this.line(content, "            existing.setPending(querySupport);");
        this.line(content, "            return existing;");
        this.line(content, "        }");
        this.line(content, "    }");
        this.line(content, "    if(existing.isPending()) {");
        if (signature.useNeedsToBlock) {
            this.line(content, "      if(needsToBlock)");
            this.line(content, "        waitPending(graph, existing);");
            this.line(content, "      else {");
            this.line(content, "        return null;");
            this.line(content, "      }");
        } else {
            this.line(content, "      waitPending(graph, existing);");
        }
        this.line(content, "    }");
        this.line(content, "    return existing;");
        this.line(content, "}");
        this.line(content, "");
    }

    public void generate() {
        URL classLocation = CodeGen.class.getResource(".");
        if (classLocation != null && classLocation.getProtocol().equals("file")) {
            try {
                URL resource = new URL(classLocation, ".");
                File path = new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
                String target = path.getAbsolutePath().replace("\\", "/");
                target = String.valueOf(target.replace("/bin/", "/src/")) + "/QueryCache.java";
                System.err.println("target=" + target);
                File source = new File(target);
                StringBuilder content = new StringBuilder();
                content.append("package org.simantics.db.impl.query;\n");
                content.append("\n");
                content.append("import org.simantics.db.ObjectResourceIdMap;\n");
                content.append("import org.simantics.db.RelationInfo;\n");
                content.append("import org.simantics.db.common.utils.Logger;\n");
                content.append("import org.simantics.db.exception.DatabaseException;\n");
                content.append("import org.simantics.db.impl.graph.ReadGraphImpl;\n");
                content.append("import org.simantics.db.impl.procedure.InternalProcedure;\n");
                content.append("import org.simantics.db.impl.query.QueryProcessor.SessionTask;\n");
                content.append("import org.simantics.db.procedure.AsyncMultiProcedure;\n");
                content.append("import org.simantics.db.procedure.AsyncProcedure;\n");
                content.append("import org.simantics.db.procedure.ListenerBase;\n");
                content.append("import org.simantics.db.procedure.SyncMultiProcedure;\n");
                content.append("import org.simantics.db.request.AsyncMultiRead;\n");
                content.append("import org.simantics.db.request.AsyncRead;\n");
                content.append("import org.simantics.db.request.ExternalRead;\n");
                content.append("import org.simantics.db.request.MultiRead;\n");
                content.append("import org.simantics.db.request.Read;\n");
                content.append("\n");
                content.append("public class QueryCache extends QueryCacheBase {\n");
                content.append("\n");
                this.line(content, "private static final boolean SINGLE = true;");
                content.append("\n");
                this.line(content, "public QueryCache(QuerySupport querySupport, int threads) {");
                this.line(content, "    super(querySupport, threads);");
                this.line(content, "}");
                content.append("\n");
                this.generateQuery(content, "Objects", this.signatureR2IP, true, false);
                this.generateQuery(content, "Statements", this.signatureR2TIP, true, false);
                this.generateQuery(content, "DirectObjects", this.signatureR2IP, true, false);
                this.generateQuery(content, "RelationInfoQuery", this.signatureR1RelationInfo, true, false);
                this.generateQuery(content, "URIToResource", this.signatureID1, true, false);
                this.generateQuery(content, "ValueQuery", this.signatureR1Bytes, true, false);
                this.generateQuery(content, "OrderedSet", this.signatureR1IP, true, false);
                this.generateQuery(content, "PrincipalTypes", this.signatureR1IP, true, false);
                this.generateQuery(content, "DirectPredicates", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "Predicates", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "ReadEntry", this.signatureRead, true, true);
                this.generateQuery(content, "AsyncReadEntry", this.signatureAsyncRead, true, true);
                this.generateQuery(content, "Types", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "ChildMap", this.signatureChildMap, true, false);
                this.generateQuery(content, "TypeHierarchy", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "SuperTypes", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "SuperRelations", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "AssertedPredicates", this.signatureR1IP, false, false);
                this.generateQuery(content, "AssertedStatements", this.signatureR2TIP, false, false);
                this.generateQuery(content, "DirectSuperRelations", this.signatureR1IP, false, false);
                this.generateQuery(content, "MultiReadEntry", this.signatureMultiRead, false, false);
                this.generateQuery(content, "AsyncMultiReadEntry", this.signatureAsyncMultiRead, false, false);
                this.generateQuery(content, "ExternalReadEntry", this.signatureExternalRead, false, false);
                content.append("}\n");
                FileUtils.writeFile((File)source, (byte[])content.toString().getBytes());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        new CodeGen().generate();
    }

    class GenerationInfo {
        String p1;
        String keyName;
        String keyToId;
        String procedure;
        boolean useNeedsToBlock;
        String entryCreationArguments;

        GenerationInfo(String p1, String keyName, String keyToId, String p4, String procedure, String entryCreationArguments, boolean useNeedsToBlock) {
            this.p1 = p1;
            this.keyName = keyName;
            this.keyToId = keyToId;
            this.procedure = procedure;
            this.useNeedsToBlock = useNeedsToBlock;
            this.entryCreationArguments = entryCreationArguments;
        }
    }
}

