/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.dialogs;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.dialogs.AnnotationConfigurator;
import org.simantics.document.ui.dialogs.Messages;
import org.simantics.document.ui.dialogs.TextInputDialog;
import org.simantics.utils.ui.validators.URLValidator;

public class UrlDetailDialog
extends TextInputDialog {
    private String url;
    private String name;
    Text urlText;
    Text nameText;
    IInputValidator urlValidator;
    IInputValidator nameValidator;
    Composite annotationComposite;
    AnnotationConfigurator annotationConfigurator;

    public UrlDetailDialog(Shell parentShell, Resource lib) {
        super(parentShell);
        try {
            this.annotationConfigurator = new AnnotationConfigurator(DocumentResource.getInstance((RequestProcessor)Simantics.getSession()).UrlDocument, lib);
        }
        catch (DatabaseException databaseException) {}
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().hint(500, 500).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.UrlDetailDialog_URL);
        this.urlText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText(Messages.UrlDetailDialog_Name);
        this.nameText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText(Messages.UrlDetailDialog_Annotations);
        this.annotationComposite = new Composite(composite, 2048);
        this.annotationComposite.setLayout((Layout)new FillLayout());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.urlText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.annotationComposite);
        this.urlValidator = new URLValidator();
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UrlDetailDialog.this.validate(UrlDetailDialog.this.urlText, UrlDetailDialog.this.urlValidator)) {
                    UrlDetailDialog.this.url = UrlDetailDialog.this.urlText.getText();
                    UrlDetailDialog.this.updateName();
                }
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UrlDetailDialog.this.validate(UrlDetailDialog.this.nameText, UrlDetailDialog.this.nameValidator)) {
                    UrlDetailDialog.this.name = UrlDetailDialog.this.nameText.getText();
                }
            }
        });
        this.annotationConfigurator.createComposite(this.annotationComposite);
        return composite;
    }

    private void updateName() {
        String newName;
        if (this.url.length() > 0 && (newName = this.updateName(this.url, this.name)) != null) {
            this.name = newName;
            this.nameText.setText(this.name);
        }
    }

    public void setUrlValidator(IInputValidator urlValidator) {
        this.urlValidator = urlValidator;
    }

    public void setNameValidator(IInputValidator nameValidator) {
        this.nameValidator = nameValidator;
    }

    public AnnotationConfigurator getAnnotationConfigurator() {
        return this.annotationConfigurator;
    }
}

