/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.simantics.document.ui.Activator;
import org.simantics.document.ui.CSSCompletionType;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;

public class CSSCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5 {
    private static final Image PRIVATE = Activator.imageDescriptorFromPlugin((String)"org.simantics.scl.ui", (String)"icons/private_co.gif").createImage();
    private static final Image PUBLIC = Activator.imageDescriptorFromPlugin((String)"org.simantics.scl.ui", (String)"icons/public_co.gif").createImage();
    private static final Image CONST = Activator.imageDescriptorFromPlugin((String)"org.simantics.scl.ui", (String)"icons/container_obj.gif").createImage();
    private static final Image TYPE = Activator.imageDescriptorFromPlugin((String)"org.simantics.scl.ui", (String)"icons/typedef_obj.gif").createImage();
    private final String content;
    private final String name;
    private final String module;
    private final String documentation;
    private int replacementOffset;
    private String prefix;
    private final CSSCompletionType completionType;
    private static final IInformationControlCreator CREATOR = new IInformationControlCreator(){

        public IInformationControl createInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    };

    public CSSCompletionProposal(SCLValue value, int replacementOffset, String prefix) {
        this.name = value.getName().name;
        this.module = value.getName().module;
        this.documentation = value.getDocumentation();
        this.content = String.valueOf(this.name) + " :: " + value.getType() + "  (" + this.module + ")";
        this.replacementOffset = replacementOffset;
        this.prefix = prefix;
        this.completionType = value.isPrivate() ? CSSCompletionType.PRIVATE : CSSCompletionType.PUBLIC;
    }

    public CSSCompletionProposal(String name, String module, CSSCompletionType completionType, int replacementOffset, String prefix) {
        this.name = name;
        this.module = module;
        this.content = String.valueOf(name) + " (" + module + ")";
        this.documentation = null;
        this.replacementOffset = replacementOffset;
        this.prefix = prefix;
        this.completionType = completionType;
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.getName().length(), 0);
    }

    public String getAdditionalProposalInfo() {
        return this.documentation;
    }

    public String getDisplayString() {
        return this.content;
    }

    public Image getImage() {
        switch (this.completionType) {
            case PRIVATE: {
                return PRIVATE;
            }
            case PUBLIC: {
                return PUBLIC;
            }
            case CONST: {
                return CONST;
            }
            case TYPE: {
                return TYPE;
            }
        }
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return 0;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            IDocument doc = viewer.getDocument();
            Point p = viewer.getSelectedRange();
            if (p.y > 0) {
                doc.replace(p.x, p.y, "");
                doc.replace(offset, 0, this.getName());
            } else {
                String currentText = doc.get(offset - this.prefix.length(), this.prefix.length());
                if (currentText.equals(this.getName())) {
                    return;
                }
                doc.replace(offset - this.prefix.length(), this.prefix.length(), "");
                doc.replace(offset - this.prefix.length(), 0, this.getName());
            }
        }
        catch (BadLocationException x) {
            x.printStackTrace();
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            String s;
            boolean a = offset >= this.replacementOffset;
            boolean b = offset < this.replacementOffset + this.getName().length();
            this.prefix = s = document.get(this.replacementOffset, offset - this.replacementOffset);
            String d = this.getName();
            boolean c = d.toLowerCase().startsWith(s.toLowerCase());
            return a && b && c;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public IInformationControlCreator getInformationControlCreator() {
        return CREATOR;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getName();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.replacementOffset - this.prefix.length();
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.documentation;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrivate() {
        return CSSCompletionType.PRIVATE == this.completionType;
    }

    public String getModule() {
        return this.module;
    }
}

