/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TUnion;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class Skeletons {
    public static Type canonicalSkeleton(Type type) {
        while (type instanceof TMetaVar) {
            TMetaVar metaVar = (TMetaVar)type;
            if (metaVar.ref != null) {
                type = metaVar.ref;
                continue;
            }
            if (metaVar.skeletonRef != null) {
                metaVar.skeletonRef = Skeletons.canonicalSkeleton(metaVar.skeletonRef);
                return metaVar.skeletonRef;
            }
            return metaVar;
        }
        return type;
    }

    public static Type canonicalSkeleton(THashMap<TMetaVar, Type> unifications, Type type) {
        while (type instanceof TMetaVar) {
            TMetaVar metaVar = (TMetaVar)type;
            if (metaVar.ref != null) {
                type = metaVar.ref;
                continue;
            }
            if (metaVar.skeletonRef != null) {
                type = metaVar.skeletonRef;
                continue;
            }
            Type temp = (Type)unifications.get((Object)metaVar);
            if (temp == null) {
                return metaVar;
            }
            type = temp;
        }
        return type;
    }

    public static boolean doesSkeletonContain(THashMap<TMetaVar, Type> unifications, Type type, TMetaVar metaVar) {
        if ((type = Skeletons.canonicalSkeleton(unifications, type)) == metaVar) {
            return true;
        }
        if (type instanceof TFun) {
            TFun fun = (TFun)type;
            return Skeletons.doesSkeletonContain(unifications, fun.domain, metaVar) || Skeletons.doesSkeletonContain(unifications, fun.range, metaVar);
        }
        if (type instanceof TApply) {
            TApply apply = (TApply)type;
            return Skeletons.doesSkeletonContain(unifications, apply.function, metaVar) || Skeletons.doesSkeletonContain(unifications, apply.parameter, metaVar);
        }
        if (type instanceof TForAll) {
            TForAll forAll = (TForAll)type;
            return Skeletons.doesSkeletonContain(unifications, forAll.type, metaVar);
        }
        if (type instanceof TPred) {
            TPred pred = (TPred)type;
            Type[] typeArray = pred.parameters;
            int n = pred.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Type param = typeArray[n2];
                if (Skeletons.doesSkeletonContain(unifications, param, metaVar)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    public static boolean areSkeletonsCompatible(THashMap<TMetaVar, Type> unifications, Type a, Type b) {
        if ((a = Skeletons.canonicalSkeleton(unifications, a)) == (b = Skeletons.canonicalSkeleton(unifications, b))) {
            return true;
        }
        Class<?> ca = a.getClass();
        Class<?> cb = b.getClass();
        if (ca == TMetaVar.class) {
            TMetaVar ma = (TMetaVar)a;
            if (Skeletons.doesSkeletonContain(unifications, b, ma)) {
                return false;
            }
            unifications.put((Object)ma, (Object)b);
            return true;
        }
        if (cb == TMetaVar.class) {
            TMetaVar mb = (TMetaVar)b;
            if (Skeletons.doesSkeletonContain(unifications, a, mb)) {
                return false;
            }
            unifications.put((Object)mb, (Object)a);
            return true;
        }
        if (ca != cb) {
            return false;
        }
        if (ca == TFun.class) {
            TFun funA = (TFun)a;
            TFun funB = (TFun)b;
            return Skeletons.areSkeletonsCompatible(unifications, funA.domain, funB.domain) && Skeletons.areSkeletonsCompatible(unifications, funA.range, funB.range);
        }
        if (ca == TApply.class) {
            TApply applyA = (TApply)a;
            TApply applyB = (TApply)b;
            return Skeletons.areSkeletonsCompatible(unifications, applyA.function, applyB.function) && Skeletons.areSkeletonsCompatible(unifications, applyA.parameter, applyB.parameter);
        }
        if (ca == TPred.class) {
            TPred predA = (TPred)a;
            TPred predB = (TPred)b;
            if (predA.typeClass != predB.typeClass) {
                return false;
            }
            int i = 0;
            while (i < predA.parameters.length) {
                if (!Skeletons.areSkeletonsCompatible(unifications, predA.parameters[i], predB.parameters[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (ca == TForAll.class) {
            TForAll forAllA = (TForAll)a;
            TForAll forAllB = (TForAll)b;
            TVar temp = Types.var(forAllA.var.getKind());
            return Skeletons.areSkeletonsCompatible(unifications, forAllA.type.replace(forAllA.var, temp), forAllB.type.replace(forAllB.var, temp));
        }
        return false;
    }

    public static void unifySkeletons(Type a, Type b) throws UnificationException {
        Class<?> cb;
        if ((a = Skeletons.canonicalSkeleton(a)) == (b = Skeletons.canonicalSkeleton(b))) {
            return;
        }
        if (a instanceof TMetaVar) {
            ((TMetaVar)a).setSkeletonRef(b);
            return;
        }
        if (b instanceof TMetaVar) {
            ((TMetaVar)b).setSkeletonRef(a);
            return;
        }
        Class<?> ca = a.getClass();
        if (ca != (cb = b.getClass())) {
            throw new UnificationException(a, b);
        }
        if (ca == TApply.class) {
            Types.unify(a, b);
        } else if (ca == TFun.class) {
            Skeletons.unifySkeletons((TFun)a, (TFun)b);
        } else if (ca == TForAll.class) {
            Skeletons.unifySkeletons((TForAll)a, (TForAll)b);
        } else if (ca == TPred.class) {
            Types.unify(a, b);
        } else if (ca == TUnion.class) {
            Skeletons.unifySkeletons((TUnion)a, (TUnion)b);
        } else {
            throw new UnificationException(a, b);
        }
    }

    public static void unifySkeletons(TFun a, TFun b) throws UnificationException {
        Skeletons.unifySkeletons(a.domain, b.domain);
        Skeletons.unifySkeletons(a.range, b.range);
    }

    public static void unifySkeletons(TApply a, TApply b) throws UnificationException {
        Skeletons.unifySkeletons(a.function, b.function);
        Skeletons.unifySkeletons(a.parameter, b.parameter);
    }

    public static void unifySkeletons(TForAll a, TForAll b) throws UnificationException {
        try {
            Kinds.unify(a.var.getKind(), b.var.getKind());
        }
        catch (KindUnificationException kindUnificationException) {
            throw new UnificationException(a, b);
        }
        TVar newVar = Types.var(a.var.getKind());
        Skeletons.unifySkeletons(a.type.replace(a.var, newVar), b.type.replace(b.var, newVar));
    }

    public static void unifySkeletons(TPred a, TPred b) throws UnificationException {
        if (a.typeClass != b.typeClass || a.parameters.length != b.parameters.length) {
            throw new UnificationException(a, b);
        }
        int i = 0;
        while (i < a.parameters.length) {
            Skeletons.unifySkeletons(a.parameters[i], b.parameters[i]);
            ++i;
        }
    }

    public static void unifySkeletons(TUnion a, TUnion b) throws UnificationException {
    }

    public static Type commonSkeleton(Environment context, Type[] types) {
        THashMap<Type[], TMetaVar> metaVarMap = new THashMap<Type[], TMetaVar>(){

            protected boolean equals(Object a, Object b) {
                return Types.equals((Type[])a, (Type[])b);
            }

            protected int hash(Object a) {
                Type[] types = (Type[])a;
                int hash = 0;
                Type[] typeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    hash = type.hashCode(hash);
                    ++n2;
                }
                return hash;
            }
        };
        return Skeletons.commonSkeleton(context, metaVarMap, types);
    }

    private static TMetaVar metaVarFor(Environment context, THashMap<Type[], TMetaVar> metaVarMap, Type[] types) {
        TMetaVar result = (TMetaVar)metaVarMap.get((Object)types);
        if (result == null) {
            try {
                result = Types.metaVar(types[0].inferKind(context));
            }
            catch (KindUnificationException kindUnificationException) {
                result = Types.metaVar(Kinds.STAR);
            }
            metaVarMap.put((Object)types, (Object)result);
        }
        return result;
    }

    private static Type commonSkeleton(Environment context, THashMap<Type[], TMetaVar> metaVarMap, Type[] types) {
        int i = 0;
        while (i < types.length) {
            types[i] = Skeletons.canonicalSkeleton(types[i]);
            ++i;
        }
        Type first = types[0];
        Class<?> clazz = first.getClass();
        int i2 = 1;
        while (i2 < types.length) {
            if (types[i2].getClass() != clazz) {
                return Skeletons.metaVarFor(context, metaVarMap, types);
            }
            ++i2;
        }
        if (clazz == TCon.class) {
            i2 = 1;
            while (i2 < types.length) {
                if (types[i2] != first) {
                    return Skeletons.metaVarFor(context, metaVarMap, types);
                }
                ++i2;
            }
            return first;
        }
        if (clazz == TApply.class) {
            Type[] functions = new Type[types.length];
            Type[] parameters = new Type[types.length];
            int i3 = 0;
            while (i3 < types.length) {
                TApply apply = (TApply)types[i3];
                functions[i3] = apply.function;
                parameters[i3] = apply.parameter;
                ++i3;
            }
            return Types.apply(Skeletons.commonSkeleton(context, metaVarMap, functions), Skeletons.commonSkeleton(context, metaVarMap, parameters));
        }
        if (clazz == TFun.class) {
            Type[] domains = new Type[types.length];
            Type[] effects = new Type[types.length];
            Type[] ranges = new Type[types.length];
            int i4 = 0;
            while (i4 < types.length) {
                TFun fun = (TFun)types[i4];
                if (fun.domain instanceof TPred) {
                    return Skeletons.metaVarFor(context, metaVarMap, types);
                }
                domains[i4] = fun.domain;
                effects[i4] = fun.effect;
                ranges[i4] = fun.range;
                ++i4;
            }
            return Types.functionE(Skeletons.commonSkeleton(context, metaVarMap, domains), Skeletons.commonEffect(effects), Skeletons.commonSkeleton(context, metaVarMap, ranges));
        }
        return Skeletons.metaVarFor(context, metaVarMap, types);
    }

    private static Type commonEffect(Type[] effects) {
        Type first = effects[0];
        int i = 1;
        while (i < effects.length) {
            if (!Types.equals(first, effects[i])) {
                return Types.metaVar(Kinds.EFFECT);
            }
            ++i;
        }
        return first;
    }

    public static boolean equalSkeletons(TApply a, TApply b) {
        return Skeletons.equalSkeletons(a.parameter, b.parameter) && Skeletons.equalSkeletons(a.function, b.function);
    }

    public static boolean equalSkeletons(TFun a, TFun b) {
        return Skeletons.equalSkeletons(a.domain, b.domain) && Skeletons.equalSkeletons(a.range, b.range);
    }

    public static boolean equalSkeletons(TForAll a, TForAll b) {
        Kind aKind = a.var.getKind();
        if (!Kinds.equalsCanonical(aKind, b.var.getKind())) {
            return false;
        }
        TVar newVar = Types.var(aKind);
        return Skeletons.equalSkeletons(a.type.replace(a.var, newVar), b.type.replace(b.var, newVar));
    }

    public static boolean equalSkeletons(TPred a, TPred b) {
        if (a.typeClass != b.typeClass || a.parameters.length != b.parameters.length) {
            return false;
        }
        Type[] aParameters = a.parameters;
        Type[] bParameters = b.parameters;
        int i = 0;
        while (i < aParameters.length) {
            if (!Skeletons.equalSkeletons(aParameters[i], bParameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalSkeletons(Type a, Type b) {
        Class<?> cb;
        if ((a = Skeletons.canonicalSkeleton(a)) == (b = Skeletons.canonicalSkeleton(b))) {
            return true;
        }
        Class<?> ca = a.getClass();
        if (ca != (cb = b.getClass())) {
            return false;
        }
        if (ca == TApply.class) {
            return Skeletons.equalSkeletons((TApply)a, (TApply)b);
        }
        if (ca == TFun.class) {
            return Skeletons.equalSkeletons((TFun)a, (TFun)b);
        }
        if (ca == TForAll.class) {
            return Skeletons.equalSkeletons((TForAll)a, (TForAll)b);
        }
        if (ca == TPred.class) {
            return Skeletons.equalSkeletons((TPred)a, (TPred)b);
        }
        return false;
    }
}

