/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.types.Type;

public class QMapping
extends Query {
    public final MappingRelation mappingRelation;
    public final Expression[] parameters;

    public QMapping(MappingRelation mappingRelation, Expression[] parameters) {
        this.mappingRelation = mappingRelation;
        this.parameters = parameters;
    }

    @Override
    public void checkType(TypingContext context) {
        Type[] parameterTypes = this.mappingRelation.parameterTypes;
        if (parameterTypes.length != this.parameters.length) {
            context.getErrorLog().log(this.location, "Relation is applied with wrong number of parameters.");
        } else {
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i] = this.parameters[i].checkType(context, parameterTypes[i]);
                ++i;
            }
        }
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context) throws UnsolvableQueryException {
        throw new InternalCompilerError();
    }

    @Override
    public Query replace(ReplaceContext context) {
        return new QMapping(this.mappingRelation, Expression.replace(context, this.parameters));
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                parameter.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }
}

