/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.list;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.list.CompiledQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierTransformer;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierVisitor;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class ListThen
extends ListQualifier {
    public ListQualifier left;
    public Expression transformer;
    public Expression by;
    TMetaVar cType;

    public ListThen(Expression transformer, Expression by) {
        this.transformer = transformer;
        this.by = by;
    }

    public void setLeft(ListQualifier inner) {
        this.left = inner;
    }

    @Override
    public void checkType(TypingContext context) {
        this.left.checkType(context);
        this.cType = Types.metaVar(Kinds.STAR);
        Type transformerType = Types.function(Types.list(this.cType), Types.list(this.cType));
        if (this.by != null) {
            this.by = this.by.checkType(context, Types.metaVar(Kinds.STAR));
            transformerType = Types.function(Types.function((Type)this.cType, this.by.getType()), transformerType);
        }
        this.transformer = this.transformer.checkType(context, transformerType);
        if (!(Types.canonical(this.cType) instanceof TMetaVar)) {
            context.getErrorLog().log(this.location, "Transformation function must be generic on list elements.");
        }
    }

    @Override
    public CompiledQualifier compile(SimplificationContext context) {
        CompiledQualifier q = this.left.compile(context);
        try {
            Types.unify(this.cType, q.pattern.getType());
        }
        catch (UnificationException unificationException) {
            context.getErrorLog().log(this.location, "Transformation function must be generic on list elements.");
        }
        q.value = this.by == null ? context.apply(this.transformer, q.value) : context.apply(this.transformer, context.lambda(q.pattern.copy(), this.by), q.value);
        return q;
    }

    @Override
    public void resolve(TranslationContext context) {
        this.transformer = this.transformer.resolve(context);
        this.left.resolve(context);
        if (this.by != null) {
            this.by = this.by.resolve(context);
        }
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.left.setLocationDeep(loc);
            this.transformer.setLocationDeep(loc);
            if (this.by != null) {
                this.by.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ListQualifierVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ListQualifier accept(ListQualifierTransformer transformer) {
        return transformer.transform(this);
    }
}

