/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.planning.items;

import gnu.trove.TIntCollection;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRRelation;
import org.simantics.scl.compiler.elaboration.chr.plan.CheckOp;
import org.simantics.scl.compiler.elaboration.chr.plan.IterateConstraintOp;
import org.simantics.scl.compiler.elaboration.chr.plan.IterateRelationOp;
import org.simantics.scl.compiler.elaboration.chr.planning.PrePlanItem;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.chr.relations.ExternalCHRRelation;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;

public class GenericPrePlanItem
extends PrePlanItem {
    public CHRLiteral literal;
    public CHRRelation relation;
    public Expression[] expressions;
    public TIntHashSet[] variableSets;
    TIntHashSet allVars;

    public GenericPrePlanItem(CHRLiteral literal, CHRRelation relation, Expression[] expressions, TIntHashSet[] variableSets, int secondaryPriority) {
        super(secondaryPriority);
        this.literal = literal;
        this.relation = relation;
        this.expressions = expressions;
        this.variableSets = variableSets;
        this.allVars = new TIntHashSet();
        TIntHashSet[] tIntHashSetArray = variableSets;
        int n = variableSets.length;
        int n2 = 0;
        while (n2 < n) {
            TIntHashSet variableSet = tIntHashSetArray[n2];
            this.allVars.addAll((TIntCollection)variableSet);
            ++n2;
        }
        this.updatePrimaryPriority();
    }

    private void updatePrimaryPriority() {
        SCLRelation sclRelation;
        double selectivity;
        int boundCount = 0;
        int boundMask = 0;
        int i = 0;
        while (i < this.variableSets.length) {
            if (this.variableSets[i].isEmpty()) {
                ++boundCount;
                boundMask |= 1 << i;
            }
            ++i;
        }
        this.primaryPriority = boundCount == this.variableSets.length ? 0.0 : (this.relation instanceof ExternalCHRRelation ? ((selectivity = (sclRelation = ((ExternalCHRRelation)this.relation).relation).getSelectivity(boundMask)) == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : (selectivity < 1.0 ? 0.0 : (selectivity == 1.0 ? 1.0 : 3.0 - (double)boundCount / (double)this.variableSets.length))) : 3.0 - (double)boundCount / (double)this.variableSets.length);
    }

    @Override
    public void initializeListeners(QueryPlanningContext context) {
        context.listen(this.allVars, (PrePlanItem)this);
    }

    @Override
    public void variableSolved(QueryPlanningContext context, int variableId) {
        TIntHashSet[] tIntHashSetArray = this.variableSets;
        int n = this.variableSets.length;
        int n2 = 0;
        while (n2 < n) {
            TIntHashSet variableSet = tIntHashSetArray[n2];
            variableSet.remove(variableId);
            ++n2;
        }
        this.allVars.remove(variableId);
        this.updatePrimaryPriority();
        context.priorityQueue.adjust(this);
    }

    @Override
    public void generate(QueryPlanningContext context) {
        int boundMask = 0;
        Expression[] boundExpressions = new Expression[this.expressions.length];
        Variable[] freeVariables = new Variable[this.expressions.length];
        int freeVariableCount = 0;
        int i = 0;
        while (i < this.expressions.length) {
            if (this.variableSets[i].isEmpty()) {
                boundExpressions[i] = this.expressions[i];
                boundMask |= 1 << i;
            } else {
                freeVariables[i] = ((EVariable)this.expressions[i]).getVariable();
                ++freeVariableCount;
            }
            ++i;
        }
        if (this.relation instanceof CHRConstraint) {
            context.addPlanOp(new IterateConstraintOp(this.location, (CHRConstraint)this.relation, freeVariables, boundExpressions, boundMask, this.killAfterMatch(), this.literal.passive));
        } else if (this.relation instanceof ExternalCHRRelation) {
            context.addPlanOp(new IterateRelationOp(this.location, ((ExternalCHRRelation)this.relation).relation, freeVariables, boundExpressions, this.literal.typeConstraintEvidenceParameters, boundMask));
        } else {
            throw new InternalCompilerError();
        }
        if (freeVariableCount > 1) {
            THashSet usedVariables = new THashSet(freeVariableCount);
            int i2 = 0;
            while (i2 < freeVariables.length) {
                Variable variable = freeVariables[i2];
                if (variable != null && !usedVariables.add((Object)variable)) {
                    Variable auxiliary;
                    freeVariables[i2] = auxiliary = new Variable(variable.getName(), variable.getType());
                    context.addPlanOp(new CheckOp(this.location, new EApply(this.location, (Expression)new EConstant(Builtins.EQUALS, variable.getType()), new EVariable(auxiliary), new EVariable(variable))));
                }
                ++i2;
            }
        }
        context.bind(this.allVars);
    }

    private boolean killAfterMatch() {
        return this.literal.killAfterMatch && this.relation instanceof CHRConstraint;
    }
}

