/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.simantics.Simantics;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.scl.scriptEditor.ReadSCLScriptSource;
import org.simantics.modeling.ui.scl.scriptEditor.SCLScriptSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLScriptEditorInput
implements IEditorInput,
IPersistableElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScriptEditorInput.class);
    private final String scriptURI;

    public SCLScriptEditorInput(String scriptURI) {
        this.scriptURI = scriptURI;
    }

    public String getScriptURI() {
        return this.scriptURI;
    }

    public boolean exists() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(SCLScriptSource.class)) {
            try {
                return (T)Simantics.getSession().syncRequest((Read)new ReadSCLScriptSource(this.scriptURI));
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to read SCL script source", (Throwable)e);
            }
        }
        if (adapter.equals(IPersistableElement.class)) {
            return (T)this;
        }
        return null;
    }

    public String getFactoryId() {
        return "org.simantics.modeling.ui.scl.scriptEditor.inputFactory";
    }

    public String getName() {
        int p = this.scriptURI.lastIndexOf(47);
        if (p >= 0) {
            return this.scriptURI.substring(p + 1);
        }
        return this.scriptURI;
    }

    public String getToolTipText() {
        return this.scriptURI;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.scriptURI == null ? 0 : this.scriptURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SCLScriptEditorInput other = (SCLScriptEditorInput)obj;
        return this.scriptURI.equals(other.scriptURI);
    }

    public void saveState(IMemento memento) {
        memento.putTextData(this.scriptURI);
    }
}

