/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.color.ColorFilter;
import org.simantics.scenegraph.g2d.color.Graphics2DWithColorFilter;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.TransferableProvider;
import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.utils.InitValueSupport;
import org.simantics.scenegraph.utils.NodeUtil;

public class SingleElementNode
extends TransformNode
implements InitValueSupport {
    private static final long serialVersionUID = -4982578347433716440L;
    private TransferableProvider transferableProvider;
    protected Composite composite;
    private ColorFilter colorFilter;
    protected Boolean visible = Boolean.TRUE;
    protected Boolean hidden = Boolean.FALSE;
    private transient Object key;
    private transient String typeClass;
    private transient Map<String, Object> parameters;
    protected Composite alphaComposite = null;

    public void setKey(Object key) {
        this.key = key;
    }

    public void setTypeClass(String typeClass) {
        this.typeClass = typeClass;
    }

    public Object getKey() {
        return this.key;
    }

    public String getTypeClass() {
        return this.typeClass;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public <T> T getParameter(String key) {
        Object t;
        if (this.parameters != null && (t = this.parameters.get(key)) != null) {
            return (T)t;
        }
        INode parent = NodeUtil.getNearestParentOfType(this, SingleElementNode.class);
        if (parent instanceof SingleElementNode) {
            return ((SingleElementNode)parent).getParameter(key);
        }
        return null;
    }

    public void setTransferableProvider(TransferableProvider transferableProvider) {
        if (transferableProvider != this.transferableProvider) {
            if (this.transferableProvider != null) {
                this.removeEventHandler(this);
            }
            if (transferableProvider != null) {
                this.addEventHandler(this);
            }
            this.transferableProvider = transferableProvider;
        }
    }

    @Override
    public boolean validate() {
        return this.visible != false && this.hidden == false;
    }

    @INode.SyncField(value={"composite"})
    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
    }

    @INode.SyncField(value={"visible"})
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @INode.SyncField(value={"hidden"})
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void render(Graphics2D g2d) {
        Graphics2D g;
        if (!this.visible.booleanValue() || this.hidden.booleanValue()) {
            return;
        }
        if (this.colorFilter != null) {
            g = new Graphics2DWithColorFilter(g2d, this.colorFilter);
            g.setRenderingHint(G2DRenderingHints.KEY_COLOR_FILTER, this.colorFilter);
        } else {
            g = g2d;
        }
        Composite oldComposite = null;
        if (this.composite != null) {
            oldComposite = g.getComposite();
            g.setComposite(this.composite);
        }
        if (this.alphaComposite != null) {
            if (oldComposite == null) {
                oldComposite = g.getComposite();
            }
            g.setComposite(this.alphaComposite);
        }
        super.render(g);
        if (oldComposite != null) {
            g.setComposite(oldComposite);
        }
        if (this.colorFilter != null) {
            g.setRenderingHint(G2DRenderingHints.KEY_COLOR_FILTER, null);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" [");
        if (this.composite != null) {
            sb.append("composite=(");
            AlphaComposite ac = (AlphaComposite)this.composite;
            sb.append(ac.getRule());
            sb.append(", ");
            sb.append(ac.getAlpha());
            sb.append("), ");
        }
        sb.append("visible=");
        sb.append(this.visible);
        sb.append("]");
        return sb.toString();
    }

    @INode.PropertySetter(value="alpha")
    @INode.SyncField(value={"alphaComposite"})
    public void setAlphaComposite(Composite alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    @Override
    public void initValues() {
        this.alphaComposite = null;
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            if (node instanceof InitValueSupport) {
                ((InitValueSupport)((Object)node)).initValues();
            }
            ++n2;
        }
    }

    @Override
    public void cleanup() {
        if (this.transferableProvider != null) {
            this.removeEventHandler(this);
            this.transferableProvider = null;
        }
        super.cleanup();
    }

    protected boolean isDragStartEvent(MouseEvent e) {
        return e.isControlDown();
    }

    protected boolean hitTest(MouseEvent event) {
        Rectangle2D bounds = super.getBoundsInLocal(true);
        if (bounds == null) {
            return false;
        }
        Point2D localPos = NodeUtil.worldToLocal(this, event.controlPosition, new Point2D.Double());
        double x = localPos.getX();
        double y = localPos.getY();
        boolean hit = bounds.contains(x, y);
        return hit;
    }

    @Override
    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        if (this.transferableProvider == null || !this.isDragStartEvent(e) || !this.hitTest(e)) {
            return false;
        }
        e.transferable = this.transferableProvider.create();
        return e.transferable != null;
    }

    @Override
    public int getEventMask() {
        return EventTypes.MouseDragBeginMask;
    }

    public void beforeRender(Graphics2D g) {
        g.setRenderingHint(G2DRenderingHints.KEY_BEGIN_ELEMENT, "definedElement");
    }

    public void afterRender(Graphics2D g) {
        g.setRenderingHint(G2DRenderingHints.KEY_END_ELEMENT, "definedElement");
    }
}

