/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;

public class InstancingShapeNode
extends ShapeNode {
    private static final long serialVersionUID = -681327976554446434L;
    AffineTransform[] transforms = new AffineTransform[0];
    Paint[] paints = new Paint[0];

    @INode.SyncField(value={"instances", "paints"})
    public void setInstances(AffineTransform[] transforms, Paint[] paints) {
        if (transforms.length != paints.length) {
            throw new IllegalArgumentException("transforms.length (" + transforms.length + ") != paints.length (" + paints.length + ")");
        }
        this.transforms = transforms;
        this.paints = paints;
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.shape == null) {
            return;
        }
        if (this.transforms == null || this.transforms.length == 0) {
            return;
        }
        this.setupRender(g2d);
        AffineTransform startTr = g2d.getTransform();
        Paint startPaint = g2d.getPaint();
        int i = 0;
        while (i < this.transforms.length) {
            if (this.transforms[i] != null) {
                g2d.transform(this.transforms[i]);
            }
            if (this.paints[i] != null) {
                g2d.setPaint(this.paints[i]);
            } else {
                g2d.setPaint(startPaint);
            }
            this.renderShape(g2d, this.shape);
            g2d.setTransform(startTr);
            ++i;
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.shape == null) {
            return null;
        }
        if (this.transforms == null || this.transforms.length == 0) {
            return null;
        }
        Rectangle2D result = null;
        Rectangle2D sb = this.shape.getBounds2D();
        AffineTransform[] affineTransformArray = this.transforms;
        int n = this.transforms.length;
        int n2 = 0;
        while (n2 < n) {
            AffineTransform at = affineTransformArray[n2];
            Rectangle2D instanceBounds = at.createTransformedShape(sb).getBounds2D();
            if (result == null) {
                result = instanceBounds;
            } else {
                Rectangle2D.union(result, instanceBounds, result);
            }
            ++n2;
        }
        return result;
    }
}

