/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.platform;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.simantics.Simantics;
import org.simantics.browsing.ui.platform.PageBookView;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.selectionview.PropertyPage;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.Throttler;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.SWTUtils;

public class PropertyPageView
extends PageBookView
implements ISelectionListener,
IContributedContentsView {
    private static final String EXT_POINT = "org.eclipse.ui.propertiesView";
    private static final String PROPERTY_VIEW_CONTEXT = "org.simantics.modeling.ui.properties";
    private static final String PROP_PINNED = "pinned";
    protected static final long SELECTION_CHANGE_THRESHOLD = 500L;
    private ISessionContextProvider contextProvider;
    private ISelection bootstrapSelection;
    private final boolean bootstrapOnly = false;
    private IMemento memento;
    private boolean pinSelection = false;
    private IWorkbenchPart lastPart;
    private ISelection lastSelection;
    private final Map<IWorkbenchPart, ISelection> lastSelections = new WeakHashMap<IWorkbenchPart, ISelection>();
    private ResourceManager resourceManager;
    private ImageDescriptor notPinned;
    private ImageDescriptor pinned;
    private Set<String> ignoredViews;
    ISelectionListener immediateSelectionListener = new ISelectionListener(){
        private Throttler throttler = new Throttler(SWTThread.getThreadAccess((Display)PlatformUI.getWorkbench().getDisplay()), 500, 3);

        public void selectionChanged(final IWorkbenchPart part, final ISelection selection) {
            if (PropertyPageView.this == part) {
                return;
            }
            this.throttler.schedule(new Runnable(){

                @Override
                public void run() {
                    PropertyPageView.this.doSelectionChanged(part, selection);
                }
            });
        }
    };
    Consumer<String> partNameUpdateCallback = parameter -> SWTUtils.asyncExec((Widget)this.getPageBook(), (Runnable)new Runnable((String)parameter){
        private final /* synthetic */ String val$parameter;
        {
            this.val$parameter = string;
        }

        @Override
        public void run() {
            if (!PropertyPageView.this.getPageBook().isDisposed()) {
                if (PropertyPageView.this.getPartName().equals(this.val$parameter)) {
                    return;
                }
                PropertyPageView.this.doSetPartName(this.val$parameter);
            }
        }
    });
    IPropertyListener partPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1) {
                PropertyPageView.this.updateContentDescription(PropertyPageView.this.pinSelection, PropertyPageView.this.lastPart);
            }
        }
    };

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.notPinned = BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.browsing.ui.common", (String)"icons/table_multiple.png");
        this.pinned = BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.browsing.ui.common", (String)"icons/table_multiple_pinned.png");
        IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
        cs.activateContext(PROPERTY_VIEW_CONTEXT);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return PropertyPageView.this.getContributingEditor();
                }
            };
        }
        return super.getAdapter(adapter);
    }

    private IWorkbenchPart getContributingEditor() {
        return this.getCurrentContributingPart();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        this.init(site);
    }

    @Override
    public void init(IViewSite site) throws PartInitException {
        String secondaryId = site.getSecondaryId();
        if (secondaryId != null) {
            ResourceInput resourceInput = ResourceInput.unmarshall((String)secondaryId);
        }
        super.init(site);
        this.contextProvider = Simantics.getSessionContextProvider();
        site.getPage().addSelectionListener(this.immediateSelectionListener);
        site.getPage().addPostSelectionListener((ISelectionListener)this);
    }

    public void saveState(IMemento memento) {
        if (this.memento != null) {
            memento.putMemento(this.memento);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.lastPart != null) {
            this.lastPart.removePropertyListener(this.partPropertyListener);
        }
        this.contextProvider = null;
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removeSelectionListener(this.immediateSelectionListener);
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    @Override
    protected IPage createDefaultPage(PageBook book) {
        PropertyPage page = new PropertyPage(this.getSite());
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    @Override
    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        IPropertyPage page = (IPropertyPage)part.getAdapter(IPropertyPage.class);
        if (page != null) {
            if (page instanceof IPageBookViewPage) {
                this.initPage((IPageBookViewPage)page);
            }
            page.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    @Override
    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPropertyPage page = (IPropertyPage)pageRecord.page;
        page.dispose();
        pageRecord.dispose();
    }

    @Override
    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            this.bootstrapSelection = page.getSelection();
            return page.getActivePart();
        }
        return null;
    }

    private boolean isPropertyView(IWorkbenchPart part) {
        boolean ignore = false;
        if (part instanceof IWorkbenchPart3) {
            IWorkbenchPart3 part3 = (IWorkbenchPart3)part;
            ignore = Boolean.parseBoolean(part3.getPartProperty(PROP_PINNED));
        }
        String thisId = this.getSite().getId();
        String otherId = part.getSite().getId();
        return this == part || (ignore |= otherId.startsWith(thisId));
    }

    private Set<String> getIgnoredViews() {
        if (this.ignoredViews == null) {
            this.ignoredViews = new HashSet<String>();
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            IExtensionPoint ep = registry.getExtensionPoint(EXT_POINT);
            if (ep != null) {
                IExtension[] extensions = ep.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        String id;
                        if ("excludeSources".equalsIgnoreCase(elements[j].getName()) && (id = elements[j].getAttribute("id")) != null) {
                            this.ignoredViews.add(id);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return this.ignoredViews;
    }

    private boolean isViewIgnored(String partID) {
        return this.getIgnoredViews().contains(partID);
    }

    @Override
    protected boolean isImportant(IWorkbenchPart part) {
        String partID = part.getSite().getId();
        return !this.isWorkbenchSelectionPinned() && !this.isPropertyView(part) && !this.isViewIgnored(partID);
    }

    @Override
    public void partActivated(IWorkbenchPart part) {
        IWorkbenchPart source = this.getSourcePart(part);
        super.partActivated(source);
        if (this.bootstrapSelection != null) {
            IPage page = this.getCurrentPage();
            if (page instanceof IPropertyPage) {
                IPropertyPage ppage = (IPropertyPage)page;
                ppage.selectionChanged(part, this.bootstrapSelection);
                this.updatePartName(ppage, this.bootstrapSelection);
            }
            this.bootstrapSelection = null;
        }
    }

    @Override
    public void partClosed(IWorkbenchPart part) {
        if (!this.pinSelection) {
            super.partClosed(part);
        }
    }

    @Override
    protected void partHidden(IWorkbenchPart part) {
    }

    public ISelection getLastSelection() {
        return this.lastSelection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.doSelectionChanged(part, sel);
    }

    boolean doSelectionChanged(IWorkbenchPart part, ISelection sel) {
        if (this.isPropertyView(part) || sel == null) {
            return false;
        }
        if (this.pinSelection) {
            return false;
        }
        part = this.getSourcePart(part);
        IPage page = this.getCurrentPage();
        if (page instanceof IPropertyPage) {
            boolean sameSelection;
            IPropertyPage ppage = (IPropertyPage)page;
            PageBookView.PageRec pageRec = this.getPageRec(part);
            if (pageRec == null || pageRec.page != page) {
                return false;
            }
            ISelection lastPartSelection = this.lastSelections.get(part);
            boolean bl = sameSelection = lastPartSelection != null && sel.equals(lastPartSelection);
            if (this.lastPart != null) {
                this.lastPart.removePropertyListener(this.partPropertyListener);
            }
            this.lastPart = part;
            this.lastSelection = sel;
            this.lastSelections.put(part, sel);
            if (this.lastPart != null) {
                this.lastPart.addPropertyListener(this.partPropertyListener);
            }
            this.updatePartName(ppage, sel);
            if (!sameSelection) {
                ppage.selectionChanged(part, sel);
                return true;
            }
        }
        return false;
    }

    void updatePartName(IPropertyPage ppage, ISelection sel) {
        ppage.updatePartName(sel, this.partNameUpdateCallback);
    }

    void doSetPartName(String partName) {
        if (this.contextProvider == null) {
            return;
        }
        if (partName == null) {
            partName = "Selection";
        }
        this.setPartName(partName);
    }

    public boolean isWorkbenchSelectionPinned() {
        return this.pinSelection;
    }

    public void pinWorkbenchSelection(boolean pin) {
        if (pin == this.pinSelection) {
            return;
        }
        this.pinSelection = pin;
        this.setPartProperty(PROP_PINNED, Boolean.toString(pin));
        if (pin) {
            this.setTitleImage(this.resourceManager.createImage(this.pinned));
        } else {
            this.setTitleImage(this.resourceManager.createImage(this.notPinned));
        }
        this.updateContentDescription(pin, this.lastPart);
        if (this.lastPart != null) {
            this.lastPart.removePropertyListener(this.partPropertyListener);
        }
        this.lastPart = null;
    }

    IWorkbenchPart getSourcePart(IWorkbenchPart part) {
        IWorkbenchPart source;
        IContributedContentsView view = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        if (view != null && (source = view.getContributingPart()) != null) {
            return source;
        }
        return part;
    }

    private void updateContentDescription(boolean selectionPinned, IWorkbenchPart sourcePart) {
        if (selectionPinned) {
            if (sourcePart == null) {
                this.setContentDescription("No selection");
            } else {
                sourcePart = this.getSourcePart(sourcePart);
                StringBuilder desc = new StringBuilder("Selection from ");
                if (sourcePart instanceof IEditorPart) {
                    desc.append("editor ");
                }
                if (sourcePart instanceof IViewPart) {
                    desc.append("view ");
                }
                desc.append('\'');
                desc.append(sourcePart.getTitle());
                desc.append('\'');
                this.setContentDescription(desc.toString());
            }
        } else {
            this.setContentDescription("");
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.lastPart;
    }
}

