/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.document.DocumentResource;
import org.simantics.document.DocumentVersionUtils;
import org.simantics.document.FileDocumentUtil;

public abstract class AddDocumentAction
implements ActionFactory {
    private Resource relation;

    public AddDocumentAction(ReadGraph graph, String relationUri) throws DatabaseException {
        this.relation = graph.getResource(relationUri);
    }

    protected Resource getRelation() {
        return this.relation;
    }

    protected void linkDocument(WriteGraph graph, Resource target, Resource newDocument) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(target, doc.Document)) {
            DocumentVersionUtils.createNewVersion(graph, target, newDocument, this.relation);
        } else {
            graph.claim(target, this.relation, newDocument);
            FileDocumentUtil.createUniqueName(graph, newDocument);
        }
    }
}

