/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.IContextualModification;

public interface IInstruction {
	
	public static final boolean DEBUG = false;
	public static final boolean DEBUG_MODI = false;
	public static final boolean DISABLE_MODI = false; // Disables modifications, if DEBUG_MODI is true
	                                                  // just prints intended modifications
	public static final String INDENTATION = "     ";
	
	/**
	 * Return value for query that finds no bindings.
	 */
	public static final Object FAILURE = new Object();
	
	/**
	 * 
	 * @param state
	 * @return FAILURE, if query failed
	 *         null, if query succeeded but there is only one possible binding
	 *         something else, if query succeeded and there might be more than one binding                                 
	 */
	Object query(ReadGraph g, Object[] bindings) throws DatabaseException;
	
	/**
	 * @param state
	 * @param continuation
	 * @return FAILURE, if there are no more results
	 *         null, if this was the last result
	 *         non-null, if there were one result and may be more
	 */
	Object next(ReadGraph g, Object[] bindings, Object continuation) throws DatabaseException;	
	
	IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException;
	void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException;
	IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException;
	void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException;
		
	void collectVariables(TIntHashSet reads, TIntHashSet writes);
	void mapVariables(TIntIntHashMap map);
	
	void toString(StringBuilder b, int indent);
	
}
