package org.simantics.diagram.stubs;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class ImageResource {
    
    public final Resource BitmapImage;
    public final Resource HasAlphaData;
    public final Resource HasAlphaData_Inverse;
    public final Resource HasIcon;
    public final Resource HasIcon_Inverse;
    public final Resource HasImage;
    public final Resource HasImageData;
    public final Resource HasImageData_Inverse;
    public final Resource HasImageDocument;
    public final Resource HasImageDocument_Inverse;
    public final Resource HasImage_Inverse;
    public final Resource HasMatrixImageIndex;
    public final Resource HasMatrixImageIndex_Inverse;
    public final Resource HasMatrixType;
    public final Resource HasMatrixType_Inverse;
    public final Resource HasPhysicalHeight;
    public final Resource HasPhysicalHeight_Inverse;
    public final Resource HasPhysicalWidth;
    public final Resource HasPhysicalWidth_Inverse;
    public final Resource HasPixelHeight;
    public final Resource HasPixelHeight_Inverse;
    public final Resource HasPixelWidth;
    public final Resource HasPixelWidth_Inverse;
    public final Resource HasRGBData;
    public final Resource HasRGBData_Inverse;
    public final Resource HasSVGDocument;
    public final Resource IconLibrary;
    public final Resource Image;
    public final Resource ImageLibrary;
    public final Resource MatrixImage;
    public final Resource SVGImage;
        
    public static class URIs {
        public static final String BitmapImage = "http://www.simantics.org/Image-1.1/BitmapImage";
        public static final String HasAlphaData = "http://www.simantics.org/Image-1.1/HasAlphaData";
        public static final String HasAlphaData_Inverse = "http://www.simantics.org/Image-1.1/HasAlphaData/Inverse";
        public static final String HasIcon = "http://www.simantics.org/Image-1.1/HasIcon";
        public static final String HasIcon_Inverse = "http://www.simantics.org/Image-1.1/HasIcon/Inverse";
        public static final String HasImage = "http://www.simantics.org/Image-1.1/HasImage";
        public static final String HasImageData = "http://www.simantics.org/Image-1.1/HasImageData";
        public static final String HasImageData_Inverse = "http://www.simantics.org/Image-1.1/HasImageData/Inverse";
        public static final String HasImageDocument = "http://www.simantics.org/Image-1.1/HasImageDocument";
        public static final String HasImageDocument_Inverse = "http://www.simantics.org/Image-1.1/HasImageDocument/Inverse";
        public static final String HasImage_Inverse = "http://www.simantics.org/Image-1.1/HasImage/Inverse";
        public static final String HasMatrixImageIndex = "http://www.simantics.org/Image-1.1/HasMatrixImageIndex";
        public static final String HasMatrixImageIndex_Inverse = "http://www.simantics.org/Image-1.1/HasMatrixImageIndex/Inverse";
        public static final String HasMatrixType = "http://www.simantics.org/Image-1.1/HasMatrixType";
        public static final String HasMatrixType_Inverse = "http://www.simantics.org/Image-1.1/HasMatrixType/Inverse";
        public static final String HasPhysicalHeight = "http://www.simantics.org/Image-1.1/HasPhysicalHeight";
        public static final String HasPhysicalHeight_Inverse = "http://www.simantics.org/Image-1.1/HasPhysicalHeight/Inverse";
        public static final String HasPhysicalWidth = "http://www.simantics.org/Image-1.1/HasPhysicalWidth";
        public static final String HasPhysicalWidth_Inverse = "http://www.simantics.org/Image-1.1/HasPhysicalWidth/Inverse";
        public static final String HasPixelHeight = "http://www.simantics.org/Image-1.1/HasPixelHeight";
        public static final String HasPixelHeight_Inverse = "http://www.simantics.org/Image-1.1/HasPixelHeight/Inverse";
        public static final String HasPixelWidth = "http://www.simantics.org/Image-1.1/HasPixelWidth";
        public static final String HasPixelWidth_Inverse = "http://www.simantics.org/Image-1.1/HasPixelWidth/Inverse";
        public static final String HasRGBData = "http://www.simantics.org/Image-1.1/HasRGBData";
        public static final String HasRGBData_Inverse = "http://www.simantics.org/Image-1.1/HasRGBData/Inverse";
        public static final String HasSVGDocument = "http://www.simantics.org/Image-1.1/HasSVGDocument";
        public static final String IconLibrary = "http://www.simantics.org/Image-1.1/IconLibrary";
        public static final String Image = "http://www.simantics.org/Image-1.1/Image";
        public static final String ImageLibrary = "http://www.simantics.org/Image-1.1/ImageLibrary";
        public static final String MatrixImage = "http://www.simantics.org/Image-1.1/MatrixImage";
        public static final String SVGImage = "http://www.simantics.org/Image-1.1/SVGImage";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public ImageResource(ReadGraph graph) {
        BitmapImage = getResourceOrNull(graph, URIs.BitmapImage);
        HasAlphaData = getResourceOrNull(graph, URIs.HasAlphaData);
        HasAlphaData_Inverse = getResourceOrNull(graph, URIs.HasAlphaData_Inverse);
        HasIcon = getResourceOrNull(graph, URIs.HasIcon);
        HasIcon_Inverse = getResourceOrNull(graph, URIs.HasIcon_Inverse);
        HasImage = getResourceOrNull(graph, URIs.HasImage);
        HasImageData = getResourceOrNull(graph, URIs.HasImageData);
        HasImageData_Inverse = getResourceOrNull(graph, URIs.HasImageData_Inverse);
        HasImageDocument = getResourceOrNull(graph, URIs.HasImageDocument);
        HasImageDocument_Inverse = getResourceOrNull(graph, URIs.HasImageDocument_Inverse);
        HasImage_Inverse = getResourceOrNull(graph, URIs.HasImage_Inverse);
        HasMatrixImageIndex = getResourceOrNull(graph, URIs.HasMatrixImageIndex);
        HasMatrixImageIndex_Inverse = getResourceOrNull(graph, URIs.HasMatrixImageIndex_Inverse);
        HasMatrixType = getResourceOrNull(graph, URIs.HasMatrixType);
        HasMatrixType_Inverse = getResourceOrNull(graph, URIs.HasMatrixType_Inverse);
        HasPhysicalHeight = getResourceOrNull(graph, URIs.HasPhysicalHeight);
        HasPhysicalHeight_Inverse = getResourceOrNull(graph, URIs.HasPhysicalHeight_Inverse);
        HasPhysicalWidth = getResourceOrNull(graph, URIs.HasPhysicalWidth);
        HasPhysicalWidth_Inverse = getResourceOrNull(graph, URIs.HasPhysicalWidth_Inverse);
        HasPixelHeight = getResourceOrNull(graph, URIs.HasPixelHeight);
        HasPixelHeight_Inverse = getResourceOrNull(graph, URIs.HasPixelHeight_Inverse);
        HasPixelWidth = getResourceOrNull(graph, URIs.HasPixelWidth);
        HasPixelWidth_Inverse = getResourceOrNull(graph, URIs.HasPixelWidth_Inverse);
        HasRGBData = getResourceOrNull(graph, URIs.HasRGBData);
        HasRGBData_Inverse = getResourceOrNull(graph, URIs.HasRGBData_Inverse);
        HasSVGDocument = getResourceOrNull(graph, URIs.HasSVGDocument);
        IconLibrary = getResourceOrNull(graph, URIs.IconLibrary);
        Image = getResourceOrNull(graph, URIs.Image);
        ImageLibrary = getResourceOrNull(graph, URIs.ImageLibrary);
        MatrixImage = getResourceOrNull(graph, URIs.MatrixImage);
        SVGImage = getResourceOrNull(graph, URIs.SVGImage);
    }
    
    public static ImageResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        ImageResource ret = session.peekService(ImageResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new ImageResource(qc.getIndependentGraph(graph));
            session.registerService(ImageResource.class, ret);
        }
        return ret;
    }
    
    public static ImageResource getInstance(RequestProcessor session) throws DatabaseException {
        ImageResource ret = session.peekService(ImageResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<ImageResource>() {
                public ImageResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new ImageResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(ImageResource.class, ret);
        }
        return ret;
    }
    
}

