package org.simantics.graph.store;

import org.simantics.graph.query.Res;

/**
 * A resource that exists only in one graph fragment. The resource
 * is represented as a integer identifier.
 * @author Hannu Niemist
 */
public class IdRes implements Res {
	public final GraphStore fragment;
	public final int id;
	
	public IdRes(GraphStore fragment, int id) {	
		this.fragment = fragment;
		this.id = id;
	}

	@Override
	public int hashCode() {
		return id * 31 + fragment.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null || getClass() != obj.getClass())
			return false;
		IdRes other = (IdRes) obj;
		return fragment == other.fragment && id == other.id;
	}	
	
	@Override
	public String toString() {
		return "#" + id;
	}
		
}
