package org.simantics.graph.matching;

import gnu.trove.map.hash.TIntIntHashMap;

import java.util.ArrayList;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class CanonicalGraph {

	int resourceCount;
	Stat[][] statements;
	TIntIntHashMap inverses = new TIntIntHashMap();
	Identity[] identities;
	String[] names;
	Variant[] values;
	
	public CanonicalGraph(TransferableGraph1 tg) {
		this.resourceCount = tg.resourceCount;
		this.identities = tg.identities;
		
		int[] oldStatements = tg.statements;
		@SuppressWarnings("unchecked")
		ArrayList<Stat>[] newStatements = new ArrayList[tg.resourceCount];
		for(int i=0;i<newStatements.length;++i)
			newStatements[i] = new ArrayList<Stat>(2);
		
		for(int i=0;i<oldStatements.length;i+=4) {
			int p = oldStatements[i+1];
			int inv = oldStatements[i+2];
			if(inv >= 0) {
				inverses.put(p, inv);
				inverses.put(inv, p);
			}
		}
		
		for(int i=0;i<oldStatements.length;i+=4) {
			int s = oldStatements[i];
			int p = oldStatements[i+1];
			int inv = oldStatements[i+2];
			int o = oldStatements[i+3];
			if(inv < 0) {
				if(inverses.contains(p))
					inv = inverses.get(p);
				else {
					inv = resourceCount++;
					inverses.put(p, inv);
					inverses.put(inv, p);
				}
			}
			newStatements[s].add(new Stat(p, o));
			newStatements[o].add(new Stat(inv, s));
		}
		
		// Statements
		Stat[][] statements = new Stat[resourceCount][];
		for(int i=0;i<tg.resourceCount;++i) {
			int size = newStatements[i].size();
			if(size == 0)
				statements[i] = Stat.NO_STATS;
			else
				statements[i] = newStatements[i].toArray(new Stat[size]);
		}
		for(int i=tg.resourceCount;i<resourceCount;++i)
			statements[i] = Stat.NO_STATS;
		this.statements = statements;
		
		// Names
		if(GraphMatching.DEBUG) {
			names = new String[resourceCount];
			for(Identity id : identities) {
				if(id.definition instanceof External)
					names[id.resource] = ((External)id.definition).name;
				else if(id.definition instanceof Internal)
					names[id.resource] = ((Internal)id.definition).name;
				else if(id.definition instanceof Optional)
					names[id.resource] = ((Optional)id.definition).name;
				else if(id.definition instanceof Root)
					names[id.resource] = "ROOT(" + ((Root)id.definition).name + ")";
			}
			for(int i=0;i<tg.resourceCount;++i)
				if(names[i] == null)
					names[i] = "r" + i;
			for(int i=tg.resourceCount;i<resourceCount;++i)
				names[i] = "inverse(" + names[inverses.get(i)] + ")";
		}
		
		// Values
		{
			Variant[] values = new Variant[resourceCount];
			for(Value value : tg.values)
				values[value.resource] = value.value;
			this.values = values;
		}
	}
	
}
