package org.simantics.graph.db;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.representation.Root;

public interface IImportAdvisor2 extends IImportAdvisor {

	public static class RootInfo {
		public Root root;
		public String name;
		public Resource resource;
		public RootInfo(Root root, String name, Resource resource) {
			this.root = root;
			this.name = name;
			this.resource = resource;
		}
	}
	
	/*
	 * This switches target to another location
	 */
	void redirect(Resource temp);
	
	Resource getTarget();
	
	@Deprecated
	Collection<Resource> getRoots();
	@Deprecated
	Collection<RootInfo> getRootInfo();
	
    void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException;
    void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException;
    boolean allowImmutableModifications();
    Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, String name) throws DatabaseException;
    Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, Resource child, String name) throws DatabaseException;
	Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException;

}
