/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.views.swt.ModelledView;

/**
 * @author Antti Villberg
 */
public class DocumentView extends ModelledView {

    private boolean pinSelection = false;

    @Override
    protected String configurationURI() {
        return DocumentUIResource.URIs.View;
    }

    @Override
    protected IPropertyPage getPropertyPage() {
        return null;
    }

    @Override
    protected void inputChanged(IWorkbenchPart provider, Object input) {
        if (pinSelection)
            return;
        super.inputChanged(provider, input);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        getViewSite().getActionBars().getToolBarManager().add(new PinSelection());
    }

    private class PinSelection extends Action {
        public PinSelection() {
            super(Messages.DocumentView_PinSelection, IAction.AS_CHECK_BOX);
            setImageDescriptor(
                    BundleUtils.getImageDescriptorFromPlugin(
                            "org.eclipse.ui", //$NON-NLS-1$
                            "icons/full/etool16/pin_editor.png")); //$NON-NLS-1$
        }

        @Override
        public void run() {
            pinSelection = isChecked();
        }
    }

}
