/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import java.util.HashMap;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;

final public class VariableRepository {

	final private static HashMap<String, Variable> repository = new HashMap<String, Variable>(); 
	
	public static synchronized void register(String uri, Variable variable) {
		repository.put(uri, variable);
	}

	public static synchronized void unregister(String uri) {
		repository.remove(uri);
	}

	public static synchronized Variable get(ReadGraph graph, String uri) throws DatabaseException {
		for(Map.Entry<String, Variable> e : repository.entrySet()) {
			if(uri.startsWith(e.getKey())) {
				return e.getValue().browse(graph, uri.substring(e.getKey().length()));
			}
		}
		throw new MissingVariableException(uri, null);
	}

	public static void clear() {
	    repository.clear();
	}
    
}
