package org.simantics.db.layer0.validation;

import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class GetConstraints extends ResourceRead<Set<Resource>> {

	public GetConstraints(Resource resource) {
		super(resource);
	}

	@Override
	public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
		
		Layer0 L0 = Layer0.getInstance(graph);
		HashSet<Resource> result = new HashSet<Resource>(); 
		for(Resource type : graph.getTypes(resource)) {
			result.addAll(graph.getObjects(type, L0.HasConstraint));
		}
		return result;
		
	}
	
}