/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceMultiRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.layer0.Layer0;
import org.simantics.project.ontology.ProjectResource;

/**
 * @author Tuukka Lehtonen
 */
public class NamespaceRequirements extends ResourceMultiRead<Resource> {

    public NamespaceRequirements(Resource project) {
        super(project);
    }

    @Override
    public void perform(ReadGraph graph, SyncMultiProcedure<Resource> callback) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        ProjectResource PROJ = ProjectResource.getInstance(graph);

        for (Resource req : graph.syncRequest(new ObjectsWithType(resource, L0.IsLinkedTo, PROJ.NamespaceRequirement))) {
            callback.execute(graph, req);
        }

        callback.finished(graph);
    }

}
