/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.db.request.WriteResult;
import org.simantics.layer0.Layer0;

public class DefaultInstanceFactoryRequest implements WriteResult<Map<String, Object>> {
	
	Resource type;
	HashMap<String, Object> parameters;
	Resource[] contexts;
	
	public DefaultInstanceFactoryRequest(Resource type, Map<String, Object> parameters,
			Resource ... contexts) {
		this.parameters = new HashMap<String, Object>(parameters);
		this.contexts = contexts;
		this.type = type;
	}
	
	public Map<String, Object> perform(WriteGraph g) throws DatabaseException {

    	Layer0 b = Layer0.getInstance(g);
		
		// Default instantiation logic
		Resource instance = g.newResource();
		g.claim(instance, b.InstanceOf, null, type);

		parameters.put("", instance);

		// Collect templates
		HashSet<Resource> templates = new HashSet<Resource>();
		for(Resource context : contexts)
			templates.addAll(g.getObjects(instance, context));

		// Apply templates
		for(Resource template : templates)
			g.adapt(template, Template.class).apply(g, parameters);

		return parameters;
		
	}
}
