/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.InputValidator;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Tuukka Lehtonen
 */
public abstract class LiteralInputValidator extends SimpleContextualAdapter<InputValidator, Variable> {

    @Override
    public InputValidator adapt(ReadGraph g, Resource source, Variable context) throws DatabaseException {
        return new InputValidator() {
            @Override
            public String isValid(Object newValue) {
                if (newValue instanceof String)
                    return validate((String) newValue);
                return "Invalid text: " + newValue;
            }
        };
    }

    protected abstract String validate(String newValue);

}
