/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import java.util.List;
import java.util.Map;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;

public interface GenericRelationIndex {

    /*
     * Returns indexed results based on this relation with given constants that
     * fulfill the specified search string.
     */
    List<Map<String, Object>> query(RequestProcessor session, String search, String bindingPattern, Object[] constants, int maxResultCount);
    List<Resource> queryResources(RequestProcessor session, String search, String bindingPattern, Object[] constants, int maxResultCount);

    /*
     * Returns indexed results based on this relation with given constants.
     * 
     * TODO: index listing is not useful like this for large indices. It needs
     * support for listing the contents in a piecewise fashion, iterating
     * through the complete index in slices.
     */
    List<Map<String, Object>> list(RequestProcessor session, String bindingPattern, Object[] constants, int maxResultCount);

    /*
     * Starts to track changes in this relation. Updates an index using the
     * IndexedRelations service.
     */
    void trackAndIndex(RequestProcessor processor, Resource input);
    void untrack(RequestProcessor processor, Resource input);

    /*
     * Rebuilds this index
     */
    void reset(RequestProcessor processor, Resource input);
    
    /*
     * The observer is fired whenever changes to the relation are observed. This
     * is applicable only after trackAndIndex has been called.
     */
    void addListener(RequestProcessor processor, Resource model, Runnable observer);
    void removeListener(RequestProcessor processor, Resource model, Runnable observer);

}
