package org.simantics.db.impl;

public class TableIntAllocatorAdapter implements IntAllocatorI {
    private Table<int[]> table;
    public TableIntAllocatorAdapter(Table<int[]> table) {
        this.table = table;
    }
    @Override
    public int allocate(int size) {
        int tableIndex = table.createNewElement(size);
        return table.checkIndexAndGetRealIndex(tableIndex, size);
    }
    @Override
    public int[] getTable() {
        return table.getTable();
    }
}
