/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl.contribution;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

public abstract class FinalLabelDecoratorContributionImpl
extends LabelDecorator.Stub {
    final LabelDecorator FRESH = new LabelDecorator.Stub();
    final LabelDecorator PENDING = new LabelDecorator.Stub();
    final LabelDecorator NO_DECORATION = new LabelDecorator.Stub();
    protected final PrimitiveQueryUpdater updater;
    private final ResourceQuery<LabelDecorator> labelQuery;
    private final BuiltinKeys.LabelDecoratorKey key;
    protected LabelDecorator decorator = this.FRESH;
    protected final NodeContext context;

    public Object getIdentity(BuiltinKeys.LabelDecoratorKey key) {
        return key;
    }

    private void request() {
        DataSource source = this.updater.getDataSource(AsyncReadGraph.class);
        assert (source != null);
        Procedure<LabelDecorator> procedure = this.createProcedure();
        source.schedule(graph -> {
            if (procedure instanceof Listener) {
                graph.asyncRequest(this.labelQuery, (Listener)procedure);
            } else {
                graph.asyncRequest(this.labelQuery, procedure);
            }
        });
    }

    public <Color_> Color_ decorateBackground(Color_ color, String column, int itemIndex) {
        if (this.FRESH == this.decorator) {
            this.decorator = this.PENDING;
            this.request();
        }
        return (Color_)this.decorator.decorateBackground(color, column, itemIndex);
    }

    public <Font_> Font_ decorateFont(Font_ font, String column, int itemIndex) {
        if (this.FRESH == this.decorator) {
            this.decorator = this.PENDING;
            this.request();
        }
        return (Font_)this.decorator.decorateFont(font, column, itemIndex);
    }

    public String decorateLabel(String label, String column, int itemIndex) {
        if (this.FRESH == this.decorator) {
            this.decorator = this.PENDING;
            this.request();
        }
        return this.decorator.decorateLabel(label, column, itemIndex);
    }

    public <Color_> Color_ decorateForeground(Color_ color, String column, int itemIndex) {
        if (this.FRESH == this.decorator) {
            this.decorator = this.PENDING;
            this.request();
        }
        return (Color_)this.decorator.decorateForeground(color, column, itemIndex);
    }

    public FinalLabelDecoratorContributionImpl(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.LabelDecoratorKey key) {
        this.updater = updater;
        this.context = context;
        this.key = key;
        this.labelQuery = new ResourceQuery<LabelDecorator>(this.getIdentity(key), context){

            public LabelDecorator perform(ReadGraph graph) throws DatabaseException {
                try {
                    return FinalLabelDecoratorContributionImpl.this.getDecorator(graph, this.context);
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((String)"LazyGraphLabeler.labelQuery produced unexpected exception.", (Throwable)t);
                    return null;
                }
            }

            public String toString() {
                return (Object)((Object)FinalLabelDecoratorContributionImpl.this) + " with context " + this.context;
            }
        };
    }

    protected Procedure<LabelDecorator> createProcedure() {
        return new Procedure<LabelDecorator>(){

            public void execute(LabelDecorator result) {
                FinalLabelDecoratorContributionImpl.this.replaceResult(result);
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((String)"LazyContributionImpl.childQuery failed, see exception for details.", (Throwable)t);
            }
        };
    }

    protected void replaceResult(LabelDecorator result) {
        if (result == null) {
            result = this.NO_DECORATION;
        }
        this.decorator = result;
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    public abstract LabelDecorator getDecorator(ReadGraph var1, NodeContext var2) throws DatabaseException;
}

