/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.update.model.UpdateOp;
import org.simantics.interop.update.model.UpdateStatus;
import org.simantics.layer0.Layer0;

public class UpdateNode {
    private UpdateNode parent;
    private UpdateStatus status;
    private UpdateOp op;
    private Resource r;
    private String label;
    private boolean visible = true;
    private Collection<UpdateNode> children = new ArrayList<UpdateNode>();

    public UpdateNode(ReadGraph g, UpdateStatus status, UpdateOp op) throws DatabaseException {
        this.status = status;
        this.op = op;
        this.r = op.getResource();
        this.init(g);
    }

    public UpdateNode(ReadGraph g, UpdateStatus status, Resource r) throws DatabaseException {
        this.status = status;
        this.op = null;
        this.r = r;
        this.init(g);
    }

    protected void init(ReadGraph g) throws DatabaseException {
        this.label = this.getLabel(g, this.r);
    }

    public Resource getResource() {
        return this.r;
    }

    public Resource getParentResource(ReadGraph g) throws DatabaseException {
        Resource parent;
        if (this.op != null && (parent = this.op.getParentResource(g)) != null) {
            return parent;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        return g.getPossibleObject(this.r, l0.PartOf);
    }

    public void setStatus(UpdateStatus status) {
        this.status = status;
    }

    public UpdateStatus getStatus() {
        return this.status;
    }

    public Collection<UpdateNode> getChildren() {
        return this.children;
    }

    public void addChild(UpdateNode node) {
        this.children.add(node);
        node.parent = this;
        if (this.op != null && node.op != null && !this.op.getSubOps().contains(node.op)) {
            this.op.addSubOp(node.op);
            node.op.addParentOp(this.op);
        }
    }

    public ImageDescriptor getImage(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    protected String getLabel(ReadGraph graph, Resource r) throws DatabaseException {
        String label = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)r);
        if (label.length() == 0) {
            label = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
        }
        return label;
    }

    public UpdateOp getOp() {
        return this.op;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.op != null) {
            this.op.visible = visible;
        }
        if (visible) {
            if (this.parent != null && !this.parent.visible) {
                this.parent.setVisible(true);
            }
        } else {
            for (UpdateNode n : this.children) {
                n.setVisible(false);
            }
        }
    }

    public void setAllVisible(boolean visible) {
        this.visible = visible;
        if (this.op != null) {
            this.op.visible = visible;
        }
        for (UpdateNode n : this.children) {
            n.setAllVisible(visible);
        }
    }
}

