/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.AddDeleteUpdateOp;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class PropertyChange {
    protected GraphChanges changes;
    protected Resource leftSubject;
    protected Resource rightSubject;
    protected Pair<Statement, Statement> pair;
    protected boolean applied = false;
    protected boolean selected = false;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected Object customValue = null;

    public PropertyChange(GraphChanges changes, Resource left, Statement first, Resource right, Statement second) {
        if (first == null && second == null) {
            throw new IllegalArgumentException("At least one of the stamenents must be non null.");
        }
        if (left == null || right == null) {
            throw new IllegalArgumentException("Subject resources cannot be null.");
        }
        this.pair = new Pair((Object)first, (Object)second);
        this.changes = changes;
        this.leftSubject = left;
        this.rightSubject = right;
    }

    public PropertyChange(GraphChanges changes, Resource left, Resource right, Pair<Statement, Statement> change) {
        if (change == null || change.first == null && change.second == null) {
            throw new IllegalArgumentException("At least one of the stamenents must be non null.");
        }
        if (left == null || right == null) {
            throw new IllegalArgumentException("Subject resources cannot be null.");
        }
        this.pair = change;
        this.changes = changes;
        this.leftSubject = left;
        this.rightSubject = right;
    }

    public Resource getFirstSubject() {
        return this.leftSubject;
    }

    public Statement getFirst() {
        return (Statement)this.pair.first;
    }

    public Resource getSecondSubject() {
        return this.rightSubject;
    }

    public Statement getSecond() {
        return (Statement)this.pair.second;
    }

    public Resource getPredicate() {
        if (this.pair.first != null) {
            return ((Statement)this.pair.first).getPredicate();
        }
        return ((Statement)this.pair.second).getPredicate();
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    public int hashCode() {
        return this.pair.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PropertyChange c = (PropertyChange)obj;
        if (!this.leftSubject.equals(c.leftSubject)) {
            return false;
        }
        if (!this.rightSubject.equals(c.rightSubject)) {
            return false;
        }
        if (this.pair.first != null && ((Statement)this.pair.first).equals(c.pair.first)) {
            return true;
        }
        return this.pair.second != null && ((Statement)this.pair.second).equals(c.pair.second);
    }

    public void apply(WriteGraph graph) throws DatabaseException {
        if (this.applied) {
            return;
        }
        if (this.pair.second == null) {
            graph.deny(this.leftSubject, ((Statement)this.pair.first).getPredicate(), ((Statement)this.pair.first).getObject());
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource s = this.leftSubject;
        if (graph.isInstanceOf(((Statement)this.pair.second).getObject(), L0.Literal)) {
            Object value = null;
            if (this.customValue != null) {
                value = this.customValue;
            } else if (graph.hasValue(((Statement)this.pair.second).getObject())) {
                value = graph.getValue(((Statement)this.pair.second).getObject());
            }
            Resource pred = ((Statement)this.pair.second).getPredicate();
            if (this.getChanges().getComparable().containsRight((Object)pred)) {
                pred = (Resource)this.getChanges().getComparable().getLeft((Object)pred);
            }
            if (value != null) {
                graph.deny(s, pred);
                graph.claimLiteral(s, pred, value);
            } else {
                graph.deny(s, pred);
            }
        } else if (graph.isInstanceOf(((Statement)this.pair.second).getObject(), L0.SCLValue)) {
            Resource pred = ((Statement)this.pair.second).getPredicate();
            graph.deny(s, pred);
            Resource valueResource = graph.newResource();
            graph.claim(valueResource, L0.InstanceOf, graph.getSingleObject(((Statement)this.pair.second).getObject(), L0.InstanceOf));
            AddDeleteUpdateOp.copyProperties(graph, ((Statement)this.pair.second).getObject(), valueResource);
            graph.claim(s, pred, valueResource);
        }
        this.applied = true;
    }

    public boolean select(boolean select) {
        if (!this.enabled) {
            return false;
        }
        if (this.applied) {
            return false;
        }
        this.selected = select;
        return true;
    }

    public boolean selected() {
        return this.selected;
    }

    public boolean applied() {
        return this.applied;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        String s = "PropertyChange";
        if (this.pair.first != null) {
            s = String.valueOf(s) + " L(" + this.leftSubject + " , " + ((Statement)this.pair.first).getPredicate() + " , " + ((Statement)this.pair.first).getObject() + ")";
        }
        if (this.pair.second != null) {
            s = String.valueOf(s) + " R(" + this.rightSubject + " , " + ((Statement)this.pair.second).getPredicate() + " , " + ((Statement)this.pair.second).getObject() + ")";
        }
        if (this.selected) {
            s = String.valueOf(s) + " selected";
        }
        if (this.enabled) {
            s = String.valueOf(s) + " enabled";
        }
        if (this.visible) {
            s = String.valueOf(s) + " visible";
        }
        if (this.applied) {
            s = String.valueOf(s) + " applied";
        }
        return s;
    }

    public Object getCustomValue() {
        return this.customValue;
    }

    public void setCustomValue(Object customValue) {
        if (this.applied) {
            throw new RuntimeException("Cannot change already applied value");
        }
        this.customValue = customValue;
    }
}

