/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.scl;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;

public class Threads {
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private static final ThreadFactory threadFactory = r -> {
        Thread t = new Thread(r, "scl-interop-thread-" + threadCount.incrementAndGet());
        t.setDaemon(true);
        return t;
    };
    private static final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(2, threadFactory);

    static {
        scheduledExecutor.setMaximumPoolSize(2);
    }

    public static void setMaximumPoolSize(int size) {
        if (size < 2) {
            return;
        }
        scheduledExecutor.setMaximumPoolSize(size);
    }

    public static SCLThread runAsync(Function f) {
        SCLContext context = SCLContext.createDerivedContext();
        SCLThread t = new SCLThread(context, f);
        scheduledExecutor.submit(t);
        return t;
    }

    public static class SCLThread
    implements Runnable {
        SCLContext context;
        Function f;
        boolean running = false;
        boolean completed = false;
        Object returnValue = null;
        Throwable error;

        public SCLThread(SCLContext context, Function f) {
            this.context = context;
            this.f = f;
        }

        @Override
        public void run() {
            block5: {
                SCLContext.push((SCLContext)this.context);
                this.running = true;
                try {
                    try {
                        this.returnValue = this.f.apply((Object)Tuple0.INSTANCE);
                    }
                    catch (Throwable t) {
                        this.error = t;
                        SCLContext.pop();
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    SCLContext.pop();
                    throw throwable;
                }
                SCLContext.pop();
            }
            this.running = false;
            this.completed = true;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public boolean hasErrors() {
            return this.error != null;
        }

        public Object getReturnValue() {
            return this.returnValue;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

