/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import org.simantics.db.Resource;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.ResourceIdentifiable;
import org.simantics.interop.mapping.data.ResourceSetSplitIdentifiable2;

public class ResourceSplitIdentifiable2
extends ResourceIdentifiable {
    private String identifier;

    public ResourceSplitIdentifiable2(Resource resource, String identifier) {
        super(resource);
        this.identifier = identifier;
    }

    public static Identifiable createIdentifiable(ResourceIdentifiable identifiable, String identifier) {
        return new ResourceSplitIdentifiable2(identifiable.getResource(), identifier);
    }

    public static Identifiable createIdentifiable(Identifiable identifiable, String identifier) {
        Resource res = identifiable.getAdapter(Resource.class);
        if (res == null) {
            return null;
        }
        Resource[] resources = identifiable.getAdapter(Resource[].class);
        if (resources.length > 1) {
            return ResourceSetSplitIdentifiable2.createIdentifiable(identifiable, identifier);
        }
        return new ResourceSplitIdentifiable2(res, identifier);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this.getClass() != arg0.getClass()) {
            return false;
        }
        ResourceSplitIdentifiable2 other = (ResourceSplitIdentifiable2)arg0;
        if (!this.identifier.equals(other.identifier)) {
            return false;
        }
        return this.resource.equals(other.resource);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Identifiable merge(Identifiable other) {
        if (other instanceof ResourceSplitIdentifiable2) {
            ResourceSplitIdentifiable2 o = (ResourceSplitIdentifiable2)other;
            if (!o.identifier.equals(this.identifier)) {
                throw new RuntimeException("Cannot be merged, Identifiers do not match " + this.identifier + " " + o.identifier);
            }
            ResourceSetSplitIdentifiable2 id = new ResourceSetSplitIdentifiable2(this.identifier, this.resource, o.resource);
            return id;
        }
        if (other instanceof ResourceSetSplitIdentifiable2) {
            ResourceSetSplitIdentifiable2 o = (ResourceSetSplitIdentifiable2)other;
            if (!o.getIdentifier().equals(this.identifier)) {
                throw new RuntimeException("Cannot be merged, Identifiers do not match " + this.identifier + " " + o.getIdentifier());
            }
            ResourceSetSplitIdentifiable2 id = new ResourceSetSplitIdentifiable2(this.resource, o.getResources(), this.identifier);
            return id;
        }
        throw new RuntimeException("Cannot be merged");
    }
}

