/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import java.util.ArrayList;
import org.simantics.db.Resource;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.ResourceSetIdentifiable;

public class ResourceIdentifiable
implements Identifiable {
    protected Resource resource;

    public ResourceIdentifiable(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz.equals(Resource.class)) {
            return (T)this.resource;
        }
        if (clazz.equals(Resource[].class)) {
            return (T)new Resource[]{this.resource};
        }
        if (clazz.equals(String.class)) {
            return (T)this.resource.toString();
        }
        return null;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this.getClass() != arg0.getClass()) {
            return false;
        }
        ResourceIdentifiable other = (ResourceIdentifiable)arg0;
        return this.resource.equals(other.resource);
    }

    @Override
    public Identifiable merge(Identifiable other) {
        if (other instanceof ResourceIdentifiable) {
            ResourceSetIdentifiable i = new ResourceSetIdentifiable(this.resource, ((ResourceIdentifiable)other).resource);
            return i;
        }
        if (other instanceof ResourceSetIdentifiable) {
            ArrayList<Resource> coll = new ArrayList<Resource>();
            coll.add(this.resource);
            coll.addAll(((ResourceSetIdentifiable)other).getResources());
            ResourceSetIdentifiable i = new ResourceSetIdentifiable(this.resource, coll);
            return i;
        }
        return null;
    }

    public String toString() {
        return this.resource.toString();
    }
}

