/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.diagram;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.diagram.Diagram;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class DiagramUtils {
    public static void addElement(WriteGraph g, Diagram diagram, Resource element) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        OrderedSetUtils.add((WriteGraph)g, (Resource)diagram.getDiagram(), (Resource)element);
        DiagramUtils.generateName(g, diagram, element);
        g.claim(diagram.getDiagram(), l0.ConsistsOf, element);
    }

    public static void addElementFirst(WriteGraph g, Diagram diagram, Resource element) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        OrderedSetUtils.addFirst((WriteGraph)g, (Resource)diagram.getDiagram(), (Resource)element);
        DiagramUtils.generateName(g, diagram, element);
        g.claim(diagram.getDiagram(), l0.ConsistsOf, element);
    }

    public static void generateName(WriteGraph g, Diagram diagram, Resource element) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        if (g.getPossibleRelatedValue(element, l0.HasName) != null) {
            return;
        }
        Resource type = g.getSingleType(element);
        String name = NameUtils.findFreshEscapedName((ReadGraph)g, (String)((String)g.getRelatedValue(type, l0.HasName)), (Resource)diagram.getDiagram(), (Resource)l0.ConsistsOf);
        g.claimLiteral(element, l0.HasName, (Object)name);
    }

    public static Resource createRelation(WriteGraph w, Layer0 b, Resource superrelation) throws DatabaseException {
        Resource relation = w.newResource();
        Resource invRelation = w.newResource();
        w.claim(relation, b.InverseOf, invRelation);
        w.claim(relation, b.ConsistsOf, invRelation);
        w.claimLiteral(invRelation, b.HasName, (Object)"Inverse");
        w.claim(relation, b.SubrelationOf, b.SuperrelationOf, superrelation);
        w.claim(invRelation, b.SubrelationOf, b.SuperrelationOf, w.getInverse(superrelation));
        return relation;
    }

    public static Resource createRelation(WriteGraph w, Layer0 b, Resource ... superrelation) throws DatabaseException {
        Resource relation = w.newResource();
        Resource invRelation = w.newResource();
        w.claim(relation, b.InverseOf, invRelation);
        w.claim(relation, b.ConsistsOf, invRelation);
        w.claimLiteral(invRelation, b.HasName, (Object)"Inverse");
        Resource[] resourceArray = superrelation;
        int n = superrelation.length;
        int n2 = 0;
        while (n2 < n) {
            Resource rel = resourceArray[n2];
            w.claim(relation, b.SubrelationOf, null, rel);
            Resource inv = w.getPossibleInverse(rel);
            if (inv != null) {
                w.claim(invRelation, b.SubrelationOf, null, inv);
            }
            ++n2;
        }
        return relation;
    }

    public static Resource getModel(ReadGraph graph, Resource res) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource sim = SimulationResource.getInstance((ReadGraph)graph);
        Resource r = res;
        while (r != null) {
            if (graph.isInstanceOf(r, sim.Model)) {
                return r;
            }
            if (graph.isInstanceOf(r, l0.SharedOntology)) {
                return r;
            }
            r = graph.getPossibleObject(r, l0.PartOf);
        }
        return r;
    }

    public static Resource getConfiguration(ReadGraph graph, Resource model) throws DatabaseException {
        SimulationResource sim = SimulationResource.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(model, sim.HasConfiguration);
    }
}

