/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.excel.poi.parser.streaming;

import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.simantics.excel.poi.parser.streaming.RowImpl;

public class CellImpl
implements Cell {
    private RowImpl row;
    private int index;

    public CellImpl(RowImpl row, int index) {
        this.row = row;
        this.index = index;
    }

    private String getType() {
        return this.row.cellTypes.get(this.index);
    }

    public boolean getBooleanCellValue() {
        return 1 == Integer.parseInt(this.getStringCellValue());
    }

    public Date getDateCellValue() {
        ExcelStyleDateFormatter formatter = new ExcelStyleDateFormatter("");
        try {
            return formatter.parse(this.getStringCellValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte getErrorCellValue() {
        return 0;
    }

    public double getNumericCellValue() {
        return Double.parseDouble(this.getStringCellValue());
    }

    public RichTextString getRichStringCellValue() {
        return null;
    }

    public String getStringCellValue() {
        return this.row.cellData.get(this.index);
    }

    public int getCellType() {
        String type = this.getType();
        if ("v".equals(type)) {
            return 0;
        }
        if ("n".equals(type)) {
            return 0;
        }
        if ("s".equals(type)) {
            return 1;
        }
        if ("b".equals(type)) {
            return 1;
        }
        if ("inlineStr".equals(type)) {
            return 1;
        }
        return 1;
    }

    public Row getRow() {
        return this.row;
    }

    public int getRowIndex() {
        return this.row.getRowNum();
    }

    public CellRangeAddress getArrayFormulaRange() {
        return null;
    }

    public int getCachedFormulaResultType() {
        return 0;
    }

    public Comment getCellComment() {
        return null;
    }

    public String getCellFormula() {
        return null;
    }

    public CellStyle getCellStyle() {
        return null;
    }

    public int getColumnIndex() {
        return this.index;
    }

    public Hyperlink getHyperlink() {
        return null;
    }

    public Sheet getSheet() {
        return this.row.getSheet();
    }

    public boolean isPartOfArrayFormulaGroup() {
        return false;
    }

    public void removeCellComment() {
    }

    public void setAsActiveCell() {
    }

    public void setCellComment(Comment comment) {
    }

    public void setCellErrorValue(byte value) {
    }

    public void setCellFormula(String formula) throws FormulaParseException {
    }

    public void setCellStyle(CellStyle style) {
    }

    public void setCellType(int cellType) {
    }

    public void setCellValue(boolean value) {
    }

    public void setCellValue(Calendar value) {
    }

    public void setCellValue(Date value) {
    }

    public void setCellValue(double value) {
    }

    public void setCellValue(RichTextString value) {
    }

    public void setCellValue(String value) {
    }

    public void setHyperlink(Hyperlink link) {
    }

    public CellAddress getAddress() {
        return new CellAddress((Cell)this);
    }

    public CellType getCachedFormulaResultTypeEnum() {
        throw new UnsupportedOperationException();
    }

    public CellType getCellTypeEnum() {
        String type = this.getType();
        if ("v".equals(type)) {
            return CellType.NUMERIC;
        }
        if ("n".equals(type)) {
            return CellType.NUMERIC;
        }
        if ("s".equals(type)) {
            return CellType.STRING;
        }
        if ("b".equals(type)) {
            return CellType.STRING;
        }
        if ("inlineStr".equals(type)) {
            return CellType.STRING;
        }
        return CellType.STRING;
    }

    public void setCellType(CellType arg0) {
        throw new UnsupportedOperationException();
    }

    public void removeHyperlink() {
        throw new UnsupportedOperationException();
    }
}

