/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashDoubleByteMap}s.
 *
 * @see HashDoubleByteMap
 * @see HashDoubleByteMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashDoubleByteMapFactory
        extends DoubleByteMapFactory<HashDoubleByteMapFactory>
        , HashContainerFactory<HashDoubleByteMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap();

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4,
            @Nonnull Map<Double, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(
            @Nonnull double[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(
            @Nonnull Map<Double, Byte> map);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4,
            @Nonnull Map<Double, Byte> map5);



    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(
            @Nonnull double[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashDoubleByteMap newMutableMapOf(double k1, byte v1);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

    @Override
    @Nonnull
     HashDoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);
    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap();

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4,
            @Nonnull Map<Double, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(
            @Nonnull Map<Double, Byte> map);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4,
            @Nonnull Map<Double, Byte> map5);



    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

    @Override
    @Nonnull
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);

    


    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4,
            @Nonnull Map<Double, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(
            @Nonnull Map<Double, Byte> map);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Map<Double, Byte> map1,
            @Nonnull Map<Double, Byte> map2,
            @Nonnull Map<Double, Byte> map3,
            @Nonnull Map<Double, Byte> map4,
            @Nonnull Map<Double, Byte> map5);



    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

    @Override
    @Nonnull
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);
}
