/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.service;

import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.OperationLogs;
import com.influxdb.client.domain.PasswordResetBody;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.User;
import com.influxdb.client.domain.Users;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface UsersService {
    @DELETE(value="api/v2/buckets/{bucketID}/members/{userID}")
    public Call<Void> deleteBucketsIDMembersID(@Path(value="userID") String var1, @Path(value="bucketID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/buckets/{bucketID}/owners/{userID}")
    public Call<Void> deleteBucketsIDOwnersID(@Path(value="userID") String var1, @Path(value="bucketID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/dashboards/{dashboardID}/members/{userID}")
    public Call<Void> deleteDashboardsIDMembersID(@Path(value="userID") String var1, @Path(value="dashboardID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/dashboards/{dashboardID}/owners/{userID}")
    public Call<Void> deleteDashboardsIDOwnersID(@Path(value="userID") String var1, @Path(value="dashboardID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/orgs/{orgID}/members/{userID}")
    public Call<Void> deleteOrgsIDMembersID(@Path(value="userID") String var1, @Path(value="orgID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/orgs/{orgID}/owners/{userID}")
    public Call<Void> deleteOrgsIDOwnersID(@Path(value="userID") String var1, @Path(value="orgID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/scrapers/{scraperTargetID}/members/{userID}")
    public Call<Void> deleteScrapersIDMembersID(@Path(value="userID") String var1, @Path(value="scraperTargetID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/scrapers/{scraperTargetID}/owners/{userID}")
    public Call<Void> deleteScrapersIDOwnersID(@Path(value="userID") String var1, @Path(value="scraperTargetID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/tasks/{taskID}/members/{userID}")
    public Call<Void> deleteTasksIDMembersID(@Path(value="userID") String var1, @Path(value="taskID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/tasks/{taskID}/owners/{userID}")
    public Call<Void> deleteTasksIDOwnersID(@Path(value="userID") String var1, @Path(value="taskID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/telegrafs/{telegrafID}/members/{userID}")
    public Call<Void> deleteTelegrafsIDMembersID(@Path(value="userID") String var1, @Path(value="telegrafID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/telegrafs/{telegrafID}/owners/{userID}")
    public Call<Void> deleteTelegrafsIDOwnersID(@Path(value="userID") String var1, @Path(value="telegrafID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/users/{userID}")
    public Call<Void> deleteUsersID(@Path(value="userID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/buckets/{bucketID}/members")
    public Call<ResourceMembers> getBucketsIDMembers(@Path(value="bucketID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/buckets/{bucketID}/owners")
    public Call<ResourceOwners> getBucketsIDOwners(@Path(value="bucketID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/dashboards/{dashboardID}/members")
    public Call<ResourceMembers> getDashboardsIDMembers(@Path(value="dashboardID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/dashboards/{dashboardID}/owners")
    public Call<ResourceOwners> getDashboardsIDOwners(@Path(value="dashboardID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/me")
    public Call<User> getMe(@Header(value="Zap-Trace-Span") String var1);

    @GET(value="api/v2/orgs/{orgID}/members")
    public Call<ResourceMembers> getOrgsIDMembers(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/orgs/{orgID}/owners")
    public Call<ResourceOwners> getOrgsIDOwners(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/scrapers/{scraperTargetID}/members")
    public Call<ResourceMembers> getScrapersIDMembers(@Path(value="scraperTargetID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/scrapers/{scraperTargetID}/owners")
    public Call<ResourceOwners> getScrapersIDOwners(@Path(value="scraperTargetID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/tasks/{taskID}/members")
    public Call<ResourceMembers> getTasksIDMembers(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/tasks/{taskID}/owners")
    public Call<ResourceOwners> getTasksIDOwners(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/telegrafs/{telegrafID}/members")
    public Call<ResourceMembers> getTelegrafsIDMembers(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/telegrafs/{telegrafID}/owners")
    public Call<ResourceOwners> getTelegrafsIDOwners(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/users")
    public Call<Users> getUsers(@Header(value="Zap-Trace-Span") String var1);

    @GET(value="api/v2/users/{userID}")
    public Call<User> getUsersID(@Path(value="userID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/users/{userID}/logs")
    public Call<OperationLogs> getUsersIDLogs(@Path(value="userID") String var1, @Header(value="Zap-Trace-Span") String var2, @Query(value="offset") Integer var3, @Query(value="limit") Integer var4);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/users/{userID}")
    public Call<User> patchUsersID(@Path(value="userID") String var1, @Body User var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/buckets/{bucketID}/members")
    public Call<ResourceMember> postBucketsIDMembers(@Path(value="bucketID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/buckets/{bucketID}/owners")
    public Call<ResourceOwner> postBucketsIDOwners(@Path(value="bucketID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/dashboards/{dashboardID}/members")
    public Call<ResourceMember> postDashboardsIDMembers(@Path(value="dashboardID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/dashboards/{dashboardID}/owners")
    public Call<ResourceOwner> postDashboardsIDOwners(@Path(value="dashboardID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/orgs/{orgID}/members")
    public Call<ResourceMember> postOrgsIDMembers(@Path(value="orgID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/orgs/{orgID}/owners")
    public Call<ResourceOwner> postOrgsIDOwners(@Path(value="orgID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/scrapers/{scraperTargetID}/members")
    public Call<ResourceMember> postScrapersIDMembers(@Path(value="scraperTargetID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/scrapers/{scraperTargetID}/owners")
    public Call<ResourceOwner> postScrapersIDOwners(@Path(value="scraperTargetID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/tasks/{taskID}/members")
    public Call<ResourceMember> postTasksIDMembers(@Path(value="taskID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/tasks/{taskID}/owners")
    public Call<ResourceOwner> postTasksIDOwners(@Path(value="taskID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/telegrafs/{telegrafID}/members")
    public Call<ResourceMember> postTelegrafsIDMembers(@Path(value="telegrafID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/telegrafs/{telegrafID}/owners")
    public Call<ResourceOwner> postTelegrafsIDOwners(@Path(value="telegrafID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/users")
    public Call<User> postUsers(@Body User var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="api/v2/me/password")
    public Call<Void> putMePassword(@Body PasswordResetBody var1, @Header(value="Zap-Trace-Span") String var2, @Header(value="Authorization") String var3);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="api/v2/users/{userID}/password")
    public Call<Void> putUsersIDPassword(@Path(value="userID") String var1, @Body PasswordResetBody var2, @Header(value="Zap-Trace-Span") String var3, @Header(value="Authorization") String var4);
}

