/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.DashboardColor;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.ViewProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HistogramViewProperties
extends ViewProperties {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.HISTOGRAM;
    public static final String SERIALIZED_NAME_QUERIES = "queries";
    @SerializedName(value="queries")
    private List<DashboardQuery> queries = new ArrayList<DashboardQuery>();
    public static final String SERIALIZED_NAME_COLORS = "colors";
    @SerializedName(value="colors")
    private List<DashboardColor> colors = new ArrayList<DashboardColor>();
    public static final String SERIALIZED_NAME_SHAPE = "shape";
    @SerializedName(value="shape")
    private ShapeEnum shape = ShapeEnum.CHRONOGRAF_V2;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_SHOW_NOTE_WHEN_EMPTY = "showNoteWhenEmpty";
    @SerializedName(value="showNoteWhenEmpty")
    private Boolean showNoteWhenEmpty;
    public static final String SERIALIZED_NAME_X_COLUMN = "xColumn";
    @SerializedName(value="xColumn")
    private String xColumn;
    public static final String SERIALIZED_NAME_FILL_COLUMNS = "fillColumns";
    @SerializedName(value="fillColumns")
    private List<String> fillColumns = new ArrayList<String>();
    public static final String SERIALIZED_NAME_X_DOMAIN = "xDomain";
    @SerializedName(value="xDomain")
    private List<Float> xDomain = new ArrayList<Float>();
    public static final String SERIALIZED_NAME_X_AXIS_LABEL = "xAxisLabel";
    @SerializedName(value="xAxisLabel")
    private String xAxisLabel;
    public static final String SERIALIZED_NAME_POSITION = "position";
    @SerializedName(value="position")
    private PositionEnum position;
    public static final String SERIALIZED_NAME_BIN_COUNT = "binCount";
    @SerializedName(value="binCount")
    private Integer binCount;

    @ApiModelProperty(required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public HistogramViewProperties queries(List<DashboardQuery> queries) {
        this.queries = queries;
        return this;
    }

    public HistogramViewProperties addQueriesItem(DashboardQuery queriesItem) {
        this.queries.add(queriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<DashboardQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DashboardQuery> queries) {
        this.queries = queries;
    }

    public HistogramViewProperties colors(List<DashboardColor> colors) {
        this.colors = colors;
        return this;
    }

    public HistogramViewProperties addColorsItem(DashboardColor colorsItem) {
        this.colors.add(colorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Colors define color encoding of data into a visualization")
    public List<DashboardColor> getColors() {
        return this.colors;
    }

    public void setColors(List<DashboardColor> colors) {
        this.colors = colors;
    }

    @ApiModelProperty(required=true, value="")
    public ShapeEnum getShape() {
        return this.shape;
    }

    public HistogramViewProperties note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public HistogramViewProperties showNoteWhenEmpty(Boolean showNoteWhenEmpty) {
        this.showNoteWhenEmpty = showNoteWhenEmpty;
        return this;
    }

    @ApiModelProperty(required=true, value="If true, will display note when empty")
    public Boolean getShowNoteWhenEmpty() {
        return this.showNoteWhenEmpty;
    }

    public void setShowNoteWhenEmpty(Boolean showNoteWhenEmpty) {
        this.showNoteWhenEmpty = showNoteWhenEmpty;
    }

    public HistogramViewProperties xColumn(String xColumn) {
        this.xColumn = xColumn;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getXColumn() {
        return this.xColumn;
    }

    public void setXColumn(String xColumn) {
        this.xColumn = xColumn;
    }

    public HistogramViewProperties fillColumns(List<String> fillColumns) {
        this.fillColumns = fillColumns;
        return this;
    }

    public HistogramViewProperties addFillColumnsItem(String fillColumnsItem) {
        this.fillColumns.add(fillColumnsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getFillColumns() {
        return this.fillColumns;
    }

    public void setFillColumns(List<String> fillColumns) {
        this.fillColumns = fillColumns;
    }

    public HistogramViewProperties xDomain(List<Float> xDomain) {
        this.xDomain = xDomain;
        return this;
    }

    public HistogramViewProperties addXDomainItem(Float xDomainItem) {
        this.xDomain.add(xDomainItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<Float> getXDomain() {
        return this.xDomain;
    }

    public void setXDomain(List<Float> xDomain) {
        this.xDomain = xDomain;
    }

    public HistogramViewProperties xAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public HistogramViewProperties position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PositionEnum getPosition() {
        return this.position;
    }

    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public HistogramViewProperties binCount(Integer binCount) {
        this.binCount = binCount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getBinCount() {
        return this.binCount;
    }

    public void setBinCount(Integer binCount) {
        this.binCount = binCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistogramViewProperties histogramViewProperties = (HistogramViewProperties)o;
        return Objects.equals((Object)this.type, (Object)histogramViewProperties.type) && Objects.equals(this.queries, histogramViewProperties.queries) && Objects.equals(this.colors, histogramViewProperties.colors) && Objects.equals((Object)this.shape, (Object)histogramViewProperties.shape) && Objects.equals(this.note, histogramViewProperties.note) && Objects.equals(this.showNoteWhenEmpty, histogramViewProperties.showNoteWhenEmpty) && Objects.equals(this.xColumn, histogramViewProperties.xColumn) && Objects.equals(this.fillColumns, histogramViewProperties.fillColumns) && Objects.equals(this.xDomain, histogramViewProperties.xDomain) && Objects.equals(this.xAxisLabel, histogramViewProperties.xAxisLabel) && Objects.equals((Object)this.position, (Object)histogramViewProperties.position) && Objects.equals(this.binCount, histogramViewProperties.binCount) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.queries, this.colors, this.shape, this.note, this.showNoteWhenEmpty, this.xColumn, this.fillColumns, this.xDomain, this.xAxisLabel, this.position, this.binCount, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistogramViewProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    colors: ").append(this.toIndentedString(this.colors)).append("\n");
        sb.append("    shape: ").append(this.toIndentedString((Object)this.shape)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    showNoteWhenEmpty: ").append(this.toIndentedString(this.showNoteWhenEmpty)).append("\n");
        sb.append("    xColumn: ").append(this.toIndentedString(this.xColumn)).append("\n");
        sb.append("    fillColumns: ").append(this.toIndentedString(this.fillColumns)).append("\n");
        sb.append("    xDomain: ").append(this.toIndentedString(this.xDomain)).append("\n");
        sb.append("    xAxisLabel: ").append(this.toIndentedString(this.xAxisLabel)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("    binCount: ").append(this.toIndentedString(this.binCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PositionEnum {
        OVERLAID("overlaid"),
        STACKED("stacked");

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PositionEnum fromValue(String text) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PositionEnum> {
            public void write(JsonWriter jsonWriter, PositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PositionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShapeEnum {
        CHRONOGRAF_V2("chronograf-v2");

        private String value;

        private ShapeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShapeEnum fromValue(String text) {
            for (ShapeEnum b : ShapeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShapeEnum> {
            public void write(JsonWriter jsonWriter, ShapeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShapeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShapeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        HISTOGRAM("histogram");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

