/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.Version;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;

public interface ServerConnection {
    public ServerInfo getServerInfo();

    public Version getProtocolVersion();

    public KeyData getKeyData();

    public ByteBufAllocator getAllocator();

    public SocketAddress getRemoteAddress();

    public TransactionStatus getTransactionStatus() throws IOException;

    public RequestExecutor getRequestExecutor();

    public ChannelFuture shutdown();

    public ChannelFuture kill();

    public boolean isConnected();

    public ScheduledExecutorService getIOExecutor();

    public static class KeyData {
        private int processId;
        private int secretKey;

        public KeyData(int processId, int secretKey) {
            this.processId = processId;
            this.secretKey = secretKey;
        }

        public int getProcessId() {
            return this.processId;
        }

        public int getSecretKey() {
            return this.secretKey;
        }
    }

    public static interface Listener {
        public void parameterStatusChanged(String var1, String var2);

        public void notificationReceived(int var1, String var2, String var3);

        public InputStream openStandardInput();

        public OutputStream openStandardOutput();

        public void closed();
    }
}

