/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.BatchResults;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.IntegerBatchResults;
import com.impossibl.postgres.jdbc.LongBatchResults;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.SQLText;
import com.impossibl.postgres.jdbc.SQLTextEscapes;
import com.impossibl.postgres.jdbc.SQLTextUtils;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultBatches;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

class PGSimpleStatement
extends PGStatement {
    private SQLText batchCommands;

    PGSimpleStatement(PGDirectConnection connection, int type, int concurrency, int holdability) {
        super(connection, type, concurrency, holdability, null, null);
    }

    private void setup(SQLText sqlText) {
        if (sqlText.getStatementCount() > 1) {
            return;
        }
        if (this.resultSetConcurrency != 1007) {
            this.name = this.connection.getNextStatementName();
            this.cursorName = "cursor" + this.name;
            if (!SQLTextUtils.prependCursorDeclaration(sqlText, this.cursorName, this.resultSetType, this.resultSetHoldability, this.connection.autoCommit)) {
                this.name = null;
                this.cursorName = null;
            }
        }
    }

    boolean execute(SQLText sqlText) throws SQLException {
        if (this.name != null) {
            PGSimpleStatement.dispose(this.connection, this.name);
            this.name = null;
        }
        if (this.processEscapes) {
            SQLTextEscapes.processEscapes(sqlText, this.connection);
        }
        this.setup(sqlText);
        boolean result = this.executeDirect(sqlText.toString());
        if (this.cursorName != null) {
            result = this.executeDirect("FETCH ABSOLUTE 0 FROM " + this.cursorName);
        }
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.connection.parseSQL(sql);
        return this.execute(sqlText);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.connection.parseSQL(sql);
        if (autoGeneratedKeys != 1) {
            return this.execute(sqlText);
        }
        if (!SQLTextUtils.appendReturningClause(sqlText)) {
            throw Exceptions.INVALID_COMMAND_FOR_GENERATED_KEYS;
        }
        this.execute(sqlText);
        this.generatedKeysResultSet = this.getResultSet();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.connection.parseSQL(sql);
        if (!SQLTextUtils.appendReturningClause(sqlText, Arrays.asList(columnNames))) {
            throw Exceptions.INVALID_COMMAND_FOR_GENERATED_KEYS;
        }
        this.execute(sqlText);
        this.generatedKeysResultSet = this.getResultSet();
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw Exceptions.NO_RESULT_SET_AVAILABLE;
        }
        return this.getResultSet();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return Long.max(this.getLargeUpdateCount(), 0L);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.execute(sql, autoGeneratedKeys)) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return Long.max(this.getLargeUpdateCount(), 0L);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.execute(sql, columnIndexes)) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return Long.max(this.getLargeUpdateCount(), 0L);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.execute(sql, columnNames)) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return Long.max(this.getLargeUpdateCount(), 0L);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long count = this.executeLargeUpdate(sql);
        return (int)Long.min(count, Integer.MAX_VALUE);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long count = this.executeLargeUpdate(sql, autoGeneratedKeys);
        return (int)Long.min(count, Integer.MAX_VALUE);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long count = this.executeLargeUpdate(sql, columnIndexes);
        return (int)Long.min(count, Integer.MAX_VALUE);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        long count = this.executeLargeUpdate(sql, columnNames);
        return (int)Long.min(count, Integer.MAX_VALUE);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.connection.parseSQL(sql);
        if (this.batchCommands == null) {
            this.batchCommands = sqlText;
        } else {
            this.batchCommands.addStatements(sqlText);
        }
    }

    @Override
    public void clearBatch() {
        this.batchCommands = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        IntegerBatchResults results = new IntegerBatchResults(this.connection.isStrictMode());
        this.executeBatch(results);
        return results.counts;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClosed();
        LongBatchResults results = new LongBatchResults(this.connection.isStrictMode());
        this.executeBatch(results);
        return results.counts;
    }

    private void executeBatch(BatchResults results) throws SQLException {
        int batchIdx = 0;
        try {
            this.warningChain = null;
            if (this.batchCommands == null) {
                return;
            }
            this.execute(this.batchCommands);
            results.setBatchSize(this.resultBatches.size());
            for (batchIdx = 0; batchIdx < this.resultBatches.size(); ++batchIdx) {
                ResultBatch resultBatch = (ResultBatch)this.resultBatches.get(batchIdx);
                if (resultBatch.getCommand().equals("SELECT")) {
                    throw results.getException(batchIdx, "SELECT in executeBatch", null);
                }
                if (resultBatch.getRowsAffected() != null) {
                    results.setUpdateCount(batchIdx, resultBatch.getRowsAffected());
                    continue;
                }
                results.setUpdateCount(batchIdx, -2L);
            }
        }
        catch (BatchUpdateException bue) {
            throw bue;
        }
        catch (SQLException se) {
            throw results.getException(batchIdx, null, se);
        }
        finally {
            this.resultBatches = ResultBatches.releaseAll(this.resultBatches);
            this.batchCommands = null;
            this.query = null;
        }
    }
}

