/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.api.data;

import com.impossibl.postgres.api.data.InetAddr;

public class CidrAddr
extends InetAddr {
    private CidrAddr(Object[] parts) {
        this((byte[])parts[0], (Short)parts[1]);
    }

    public CidrAddr(byte[] address, short maskBits) throws IllegalArgumentException {
        super(address, maskBits);
        CidrAddr.checkHostBits(address, maskBits);
    }

    public CidrAddr(String cidrAddress) throws IllegalArgumentException {
        this(CidrAddr.parseN(cidrAddress, true));
    }

    @Override
    public void setAddress(byte[] address) {
        this.address = address;
        this.maskBits = (short)(address.length * 8);
    }

    @Override
    public void setMaskBits(short maskBits) {
        CidrAddr.checkHostBits(this.address, maskBits);
        this.maskBits = maskBits;
    }

    public static CidrAddr parseCidrAddr(String cidrAddr) throws IllegalArgumentException {
        return new CidrAddr(CidrAddr.parseN(cidrAddr, true));
    }

    static void checkHostBits(byte[] address, short maskBits) throws IllegalArgumentException {
        int networkBytes = maskBits / 8;
        int networkBits = maskBits % 8;
        if (networkBytes < address.length && (address[networkBytes] & 255 >> networkBits) != 0) {
            throw new IllegalArgumentException("host bits not all zero in netmask: " + maskBits);
        }
        for (int i = networkBytes + 1; i < address.length; ++i) {
            if (address[i] == 0) continue;
            throw new IllegalArgumentException("host bits not all zero in netmask: " + maskBits);
        }
    }
}

