/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Objects;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.db.exception.DatabaseException;
import org.simantics.selectionview.ModelledTabContributor;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.client.base.SWTRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelledViewTabContributor
extends ModelledTabContributor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelledViewTabContributor.class);
    private final String viewURI;

    public ModelledViewTabContributor(String viewURI) {
        this.viewURI = viewURI;
    }

    @Override
    public void createControls(Composite body, IWorkbenchSite site) {
        try {
            SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, site);
            SWTRoot root = (SWTRoot)loader.load(this.viewURI, this.runtime);
            root.createControls(body);
            body.addListener(12, e -> {
                if (!loader.isDisposed()) {
                    loader.dispose();
                }
            });
        }
        catch (DatabaseException e2) {
            LOGGER.error("Failed to create controls for view {} and runtime {}", new Object[]{this.viewURI, this.runtime, e2});
        }
    }

    public int hashCode() {
        return this.viewURI.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelledViewTabContributor other = (ModelledViewTabContributor)obj;
        return Objects.equals(this.viewURI, other.viewURI);
    }
}

