/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.db.Resource;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.runtime.tuple.Tuple3;

public class ProfileObserverData {
    private static ProfileObserverData INSTANCE;
    protected final Map<Tuple, Object> values = new ConcurrentHashMap<Tuple, Object>();
    private Map<Tuple3, ObserverGroupListener> listeners = new HashMap<Tuple3, ObserverGroupListener>();
    private Map<Tuple2, Set<Group>> groups = new HashMap<Tuple2, Set<Group>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProfileObserverData getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ProfileObserverData> clazz = ProfileObserverData.class;
        synchronized (ProfileObserverData.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ProfileObserverData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void removeValue(Tuple t) {
        this.values.remove(t);
    }

    public void putValue(Tuple t, Object o) {
        this.values.put(t, o);
    }

    public <T> T getValue(Tuple t) {
        return (T)this.values.get(t);
    }

    public void putListener(Style style, Resource runtime, Group group, ObserverGroupListener listener) {
        this.listeners.put(new Tuple3((Object)style, (Object)runtime, (Object)group), listener);
        Set<Group> list = this.groups.get(new Tuple2((Object)style, (Object)runtime));
        if (list == null) {
            list = new HashSet<Group>();
            this.groups.put(new Tuple2((Object)style, (Object)runtime), list);
        }
        list.add(group);
    }

    public void removeListener(Style style, Resource runtime, Group group) {
        this.listeners.remove(new Tuple3((Object)style, (Object)runtime, (Object)group));
        Set<Group> list = this.groups.get(new Tuple2((Object)style, (Object)runtime));
        if (list != null) {
            list.remove(group);
            if (list.isEmpty()) {
                this.groups.remove(new Tuple2((Object)style, (Object)runtime));
            }
        }
    }

    public ObserverGroupListener getListener(Style style, Resource runtime, Group group) {
        return this.listeners.get(new Tuple3((Object)style, (Object)runtime, (Object)group));
    }

    public boolean isActive(Style style, Resource runtime, Object item) {
        for (Group group : this.groups.get(new Tuple2((Object)style, (Object)runtime))) {
            ObserverGroupListener listener = this.getListener(style, runtime, group);
            if (!listener.hasItem(item)) continue;
            return true;
        }
        return false;
    }
}

