/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.IContextualModification;

public class TripletInstruction extends Instruction3 {
	
	public TripletInstruction(int variable0, int variable1, int variable2) {
		super(variable0, variable1, variable2);
	}

	@Override
	public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
		Resource r2 = (Resource)bindings[variable2];
//		ITask task = ThreadLogger.getInstance().begin("g");
		if(!g.hasStatement(r0, r1, r2)) {
//			task.finish();		
			return new IContextualModification() {

				@Override
				public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
					Resource r0 = (Resource)bindings[variable0];
					Resource r1 = (Resource)bindings[variable1];
					Resource r2 = (Resource)bindings[variable2];
					if(DEBUG_MODI)
                        System.out.println("claim(" +
                                NameUtils.getSafeName(g, r0) + ", " +
                                NameUtils.getSafeName(g, r1) + ", " +
                                NameUtils.getSafeName(g, r2) + ")"
                                );
					if(!DISABLE_MODI)
						g.claim(r0, r1, r2);
				}
			
			};
		}
//		task.finish();
		return null;
	}
	
	@Override
	public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
		Resource r2 = (Resource)bindings[variable2];
		if(DEBUG) {
    		System.out.println("@ claim(" +
                    NameUtils.getSafeName(g, r0) + ", " +
                    NameUtils.getSafeName(g, r1) + ", " +
                    NameUtils.getSafeName(g, r2) + ")");
		}
		if(DEBUG_MODI)
            System.out.println("claim(" +
                    NameUtils.getSafeName(g, r0) + ", " +
                    NameUtils.getSafeName(g, r1) + ", " +
                    NameUtils.getSafeName(g, r2) + ")"
                    );
//		ITask task = ThreadLogger.getInstance().begin("g");    	
		if(!DISABLE_MODI)
			g.claim(r0, r1, r2);
//		task.finish();
	}

	@Override
	public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
		Resource r2 = (Resource)bindings[variable2];
		if(g.hasStatement(r0, r1, r2))
			return new IContextualModification() {

				@Override
				public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
					Resource r0 = (Resource)bindings[variable0];
					Resource r1 = (Resource)bindings[variable1];
					Resource r2 = (Resource)bindings[variable2];
					if(DEBUG_MODI)
                        System.out.println("deny(" +
                                NameUtils.getSafeName(g, r0) + ", " +
                                NameUtils.getSafeName(g, r1) + ", " +
                                NameUtils.getSafeName(g, r2) + ")"
                                );
					if(!DISABLE_MODI)
						g.denyStatement(r0, r1, r2);
				}
			
			};
		return null;
	}
	
	@Override
	public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
		Resource r2 = (Resource)bindings[variable2];
		if(DEBUG) {
    		System.out.println("deny(" +
    		        NameUtils.getSafeName(g, r0) + ", " +
    		        NameUtils.getSafeName(g, r1) + ", " +
    		        NameUtils.getSafeName(g, r2) + ")");
		}
		if(DEBUG_MODI)
            System.out.println("deny(" +
                    NameUtils.getSafeName(g, r0) + ", " +
                    NameUtils.getSafeName(g, r1) + ", " +
                    NameUtils.getSafeName(g, r2) + ")"
                    );
		if(!DISABLE_MODI)
			g.denyStatement(r0, r1, r2);		
	}

	@Override
	public Object next(ReadGraph g, Object[] bindings, Object continuation) throws DatabaseException {
		return IInstruction.FAILURE;
	}

	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
		Resource r2 = (Resource)bindings[variable2];
		if(DEBUG) {
    		System.out.print("hasStatement(" +
                    NameUtils.getSafeName(g, r0) + ", " +
                    NameUtils.getSafeName(g, r1) + ", " +
                    NameUtils.getSafeName(g, r2) + ")");
		}
		if(g.hasStatement(r0, r1, r2)) {
		    if(DEBUG)
		        System.out.println(" -> true");
			return null;
		}
		else {
		    if(DEBUG)
		        System.out.println(" -> false");
			return IInstruction.FAILURE;
		}
	}

	@Override
	public void toString(StringBuilder b, int indent) {
		b.append('<');
		b.append(variable0);
		b.append(',');
		b.append(variable1);
		b.append(',');
		b.append(variable2);
		b.append('>');
	}
}
