/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.mapping.IContextualModification;

public class ExistsInstruction implements IInstruction {

	IInstruction instruction;
	int[] variables;	
	
	public ExistsInstruction(IInstruction instruction, int ... variables) {
		this.instruction = instruction;
		this.variables = variables;
	}	

	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		instruction.collectVariables(reads, writes);
	}
	
	class Claim implements IContextualModification {
			
		public Claim() {
		}

		@Override
		public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
//			ITask task = ThreadLogger.getInstance().begin("g");
			for(int var : variables) {
				bindings[var] = DISABLE_MODI ? null : g.newResource();
				if(DEBUG)
				    System.out.println("@ newResource " + NameUtils.getSafeName(g, (Resource)bindings[var]));
                if(DEBUG_MODI)
                    System.out.println("claim exists " + NameUtils.getSafeName(g, (Resource)bindings[var]));
			}
//			task.finish();
			instruction.doClaim(g, bindings);	
		}
	}
	
	@Override
	public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
		if(instruction.query(g, bindings)==IInstruction.FAILURE) {
//			System.out.println("Creates Claim");
			return new Claim();
		}
		return null;
	}
	
	class Deny implements IContextualModification {
		Object continuation;
		
		public Deny(Object continuation) {
			this.continuation = continuation;
		}

		@Override
		public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
			Object continuation = this.continuation;
			do {
			    for(int var : variables) {
			        if(DEBUG_MODI)
			            System.out.println("deny exists " + 
			                    NameUtils.getSafeName(g, (Resource)bindings[var]));
			        if(!DISABLE_MODI)
			        	RemoverUtil.remove(g, (Resource)bindings[var]);
				}
				continuation = instruction.next(g, bindings, continuation);
			} while(continuation != null && continuation != IInstruction.FAILURE);	
		}
	}
	
	@Override
	public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
		Object continuation = instruction.query(g, bindings);
		if(continuation != IInstruction.FAILURE)
			return new Deny(continuation);
		return null;
	}

	@Override
	public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
		if(instruction.query(g, bindings)==IInstruction.FAILURE) {
//			ITask task = ThreadLogger.getInstance().begin("g");
			for(int var : variables) {
				bindings[var] = DISABLE_MODI ? null : g.newResource();
				if(DEBUG)
					System.out.println("@ newResource " + NameUtils.getSafeName(g, (Resource)bindings[var]));
				if(DEBUG_MODI)
					System.out.println("claim exists " + NameUtils.getSafeName(g, (Resource)bindings[var]));
			}			
//			task.finish();
			instruction.doClaim(g, bindings);
		}		
	}

	@Override
	public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
		Object continuation = instruction.query(g, bindings);
		if(continuation != IInstruction.FAILURE)
			do {
				for(int var : variables) {
		            if(DEBUG_MODI)
		                System.out.println("deny exists " + 
		                        NameUtils.getSafeName(g, (Resource)bindings[var]));
		            if(!DISABLE_MODI)
		            	RemoverUtil.remove(g, (Resource)bindings[var]);
				}
				continuation = instruction.next(g, bindings, continuation);
			} while(continuation != null && continuation != IInstruction.FAILURE);		
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		instruction.mapVariables(map);
		for(int i=0;i<variables.length;++i)
			variables[i] = map.get(variables[i]);
	}

	@Override
	public Object next(ReadGraph g, Object[] bindings, Object continuation) throws DatabaseException {
		return instruction.next(g, bindings, continuation);
	}

	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
		return instruction.query(g, bindings);
	}
	
	@Override
	public void toString(StringBuilder b, int indent) {
		b.append('[');
		boolean first = true;
		for(int v : variables) {
			if(first)
				first = false;
			else 
				b.append(',');
			b.append(v);		
		}
		b.append("] ");
		instruction.toString(b, indent+1);
	}

}
