/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.test;

import java.io.File;
import java.io.IOException;

import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.type.RecordType;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.CollectorImpl;
import org.simantics.history.impl.CollectorState;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.utils.FileUtils;

public class TestPerformance {

	static final double NaN = Double.NaN;
	
	// Time            0.0  0.1  0.2  0.3  0.4  0.5  0.6  0.7  0.8  0.9  1.0  1.1  1.2  1.3  1.4
	double[] data1 = { 5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 7.0, 8.0, 9.0, NaN,10.0, NaN, NaN, NaN };	
	double[] data2 = { 5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 7.0, 8.0, 9.0,10.0, 9.0, 5.0, 4.0, 3.0 };
	byte[] data3 = { 5, 6, 7, 8, 9, 10, 9, 5, 4, 3 };
	
	// Subscription formats
	SamplingFormat simple, allfields, vector, minmax, byteformat, string;

	// History
	HistoryManager historian;
	File workarea;
	Collector collector;
	
	@Test
	public void testPerformance() throws Exception {

        File workarea = FileUtils.createTmpDir();
	    
		byteformat = new SamplingFormat();
		byteformat.formatId = "byte";
		byteformat.format = new RecordType();
		RecordType format = (RecordType) (byteformat.format = new RecordType());
		format.addComponent("time", Datatypes.DOUBLE);
		format.addComponent("endTime", Datatypes.DOUBLE);
		format.addComponent("value", Datatypes.BYTE);
		format.addComponent("lastValue", Datatypes.BYTE);		
		format.addComponent("min", Datatypes.BYTE);
		format.addComponent("max", Datatypes.BYTE);
		format.addComponent("avg", Datatypes.DOUBLE);
		format.addComponent("median", Datatypes.BYTE);
		format.addComponent("quality", Datatypes.BYTE);
		format.addComponent("count", Datatypes.INTEGER);
		byteformat.interval = NaN;
		byteformat.deadband = NaN;		
		
		CollectorState cs;
		// Write data
		for (int z=0; z<20; z++) {
			cs = new CollectorState();
			historian = History.openFileHistory(workarea);
			collector = new CollectorImpl( historian );
				
			// 2. Write data
			SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", byteformat );
			historian.create( hi );
			collector.addItem( hi );
			System.gc();
			long startTime = System.nanoTime();
			double[] data = data2;
			for (int j=0; j<10000; j++) {
				for (int i=0; i<data.length; i++) 
				{
					collector.beginStep(Bindings.DOUBLE, i * 0.1);
					collector.setValue("MyVariable", Bindings.DOUBLE, data[i]);
					collector.endStep();
				}			
			}
			collector.close();
			long elapsedtime = System.nanoTime()-startTime;
			System.out.println("Elapsed: "+(elapsedtime/1000L)+"s");
		}

        if ( workarea != null) {
            try {
                FileUtils.deleteAll(workarea);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
		
	}
	
}
