/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.simantics.db.impl.query.QueryListening;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.TaskList;

class Scheduler
extends ThreadLocal<TaskList> {
    private final QueryProcessor processor;
    private static final int MAX_TASKLIST_SIZE = 256;
    private int currentTaskListSize = 1;
    private Object taskExecutionMonitor = new Object();
    private Object taskDispatchMonitor = new Object();
    private ArrayList<TaskList> dispatchedTaskLists;
    private final Map<Thread, TaskList> activeTaskLists = new HashMap<Thread, TaskList>();
    private final Semaphore taskDispatchNotifications = new Semaphore(0);

    Scheduler(QueryProcessor processor) {
        this.processor = processor;
    }

    void accept(Runnable task) {
        TaskList l = (TaskList)this.get();
        l.add(task);
        if (l.shouldSchedule()) {
            this.remove();
            this.sendToExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToExecution() {
        Map<Thread, TaskList> map = this.activeTaskLists;
        synchronized (map) {
            TaskList l = this.activeTaskLists.remove(Thread.currentThread());
            Object object = this.taskDispatchMonitor;
            synchronized (object) {
                if (this.dispatchedTaskLists == null) {
                    this.dispatchedTaskLists = new ArrayList();
                }
                this.dispatchedTaskLists.add(l);
            }
            if (this.currentTaskListSize < 256) {
                this.currentTaskListSize <<= 1;
            }
        }
        this.taskDispatchNotifications.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<TaskList> getDispatchedQueues() {
        Object object = this.taskDispatchMonitor;
        synchronized (object) {
            block4: {
                if (this.dispatchedTaskLists != null) break block4;
                return null;
            }
            ArrayList<TaskList> result = this.dispatchedTaskLists;
            this.dispatchedTaskLists = null;
            return result;
        }
    }

    void start() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Scheduler.this.processor.isDisposed()) {
                    try {
                        Object object = Scheduler.this.taskExecutionMonitor;
                        synchronized (object) {
                            ArrayList<TaskList> qs;
                            while ((qs = Scheduler.this.getDispatchedQueues()) != null) {
                                for (TaskList queue : qs) {
                                    for (Runnable r : queue) {
                                        r.run();
                                    }
                                }
                            }
                        }
                        Scheduler.this.taskDispatchNotifications.acquire();
                    }
                    catch (InterruptedException e) {
                        QueryListening.LOGGER.error("Unexpected interrupt", (Throwable)e);
                    }
                }
            }
        };
        thread.setName("QueryListening");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TaskList initialValue() {
        TaskList result = new TaskList(this.currentTaskListSize);
        Map<Thread, TaskList> map = this.activeTaskLists;
        synchronized (map) {
            this.activeTaskLists.put(Thread.currentThread(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sync() {
        Object object = this.taskExecutionMonitor;
        synchronized (object) {
            this.currentTaskListSize = 1;
            ArrayList<TaskList> qs = this.getDispatchedQueues();
            if (qs != null) {
                for (TaskList queue : qs) {
                    for (Runnable r : queue) {
                        r.run();
                    }
                }
            }
            Map<Thread, TaskList> map = this.activeTaskLists;
            synchronized (map) {
                for (TaskList queue : this.activeTaskLists.values()) {
                    for (Runnable r : queue) {
                        if (r == null) continue;
                        r.run();
                    }
                    queue.reset();
                }
            }
        }
    }
}

